/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntruprime;

import org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeKeyParameters;
import org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class NTRULPRimePrivateKeyParameters
extends NTRULPRimeKeyParameters {
    private final byte[] enca;
    private final byte[] pk;
    private final byte[] rho;
    private final byte[] hash;

    public NTRULPRimePrivateKeyParameters(NTRULPRimeParameters params, byte[] enca, byte[] pk, byte[] rho, byte[] hash) {
        super(true, params);
        this.enca = Arrays.clone(enca);
        this.pk = Arrays.clone(pk);
        this.rho = Arrays.clone(rho);
        this.hash = Arrays.clone(hash);
    }

    public byte[] getEnca() {
        return Arrays.clone(this.enca);
    }

    public byte[] getPk() {
        return Arrays.clone(this.pk);
    }

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }

    public byte[] getHash() {
        return Arrays.clone(this.hash);
    }

    public byte[] getEncoded() {
        byte[] key = new byte[this.getParameters().getPrivateKeyBytes()];
        System.arraycopy(this.enca, 0, key, 0, this.enca.length);
        System.arraycopy(this.pk, 0, key, this.enca.length, this.pk.length);
        System.arraycopy(this.rho, 0, key, this.enca.length + this.pk.length, this.rho.length);
        System.arraycopy(this.hash, 0, key, this.enca.length + this.pk.length + this.rho.length, this.hash.length);
        return key;
    }
}

