/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.mlkem;

import java.util.Arrays;
import java.util.Objects;
import javax.crypto.DecapsulateException;
import javax.crypto.KEMSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.provider.asymmetric.mlkem.BCMLKEMPrivateKey;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMExtractor;
import org.bouncycastle.pqc.jcajce.provider.util.KdfUtil;

public class MLKEMDecapsulatorSpi
implements KEMSpi.DecapsulatorSpi {
    BCMLKEMPrivateKey privateKey;
    KTSParameterSpec parameterSpec;
    MLKEMExtractor kemExt;

    public MLKEMDecapsulatorSpi(BCMLKEMPrivateKey privateKey, KTSParameterSpec parameterSpec) {
        this.privateKey = privateKey;
        this.parameterSpec = parameterSpec;
        this.kemExt = new MLKEMExtractor(privateKey.getKeyParams());
    }

    @Override
    public SecretKey engineDecapsulate(byte[] encapsulation, int from, int to, String algorithm) throws DecapsulateException {
        Objects.checkFromToIndex(from, to, this.engineSecretSize());
        Objects.requireNonNull(algorithm, "null algorithm");
        Objects.requireNonNull(encapsulation, "null encapsulation");
        if (encapsulation.length != this.engineEncapsulationSize()) {
            throw new DecapsulateException("incorrect encapsulation size");
        }
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && algorithm.equals("Generic")) {
            algorithm = this.parameterSpec.getKeyAlgorithmName();
        }
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && !this.parameterSpec.getKeyAlgorithmName().equals(algorithm)) {
            throw new UnsupportedOperationException(this.parameterSpec.getKeyAlgorithmName() + " does not match " + algorithm);
        }
        boolean useKDF = this.parameterSpec.getKdfAlgorithm() != null;
        byte[] secret = this.kemExt.extractSecret(encapsulation);
        byte[] secretKey = Arrays.copyOfRange(KdfUtil.makeKeyBytes(this.parameterSpec, secret), from, to);
        return new SecretKeySpec(secretKey, algorithm);
    }

    @Override
    public int engineSecretSize() {
        return this.parameterSpec.getKeySize() / 8;
    }

    @Override
    public int engineEncapsulationSize() {
        return this.kemExt.getEncapsulationLength();
    }
}

