/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.engines.SparkleEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

public class SparkleDigest
implements ExtendedDigest {
    private static final int RATE_BYTES = 16;
    private static final int RATE_WORDS = 4;
    private String algorithmName;
    private final int[] state;
    private final byte[] m_buf = new byte[16];
    private final int DIGEST_BYTES;
    private final int SPARKLE_STEPS_SLIM;
    private final int SPARKLE_STEPS_BIG;
    private final int STATE_WORDS;
    private int m_bufPos = 0;

    public SparkleDigest(SparkleParameters sparkleParameters) {
        switch (sparkleParameters.ordinal()) {
            case 0: {
                this.algorithmName = "ESCH-256";
                this.DIGEST_BYTES = 32;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 11;
                this.STATE_WORDS = 12;
                break;
            }
            case 1: {
                this.algorithmName = "ESCH-384";
                this.DIGEST_BYTES = 48;
                this.SPARKLE_STEPS_SLIM = 8;
                this.SPARKLE_STEPS_BIG = 12;
                this.STATE_WORDS = 16;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid definition of SCHWAEMM instance");
            }
        }
        this.state = new int[this.STATE_WORDS];
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public int getDigestSize() {
        return this.DIGEST_BYTES;
    }

    @Override
    public int getByteLength() {
        return 16;
    }

    @Override
    public void update(byte input) {
        if (this.m_bufPos == 16) {
            this.processBlock(this.m_buf, 0, this.SPARKLE_STEPS_SLIM);
            this.m_bufPos = 0;
        }
        this.m_buf[this.m_bufPos++] = input;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        int remaining;
        if (inOff > in.length - len) {
            throw new DataLengthException(this.algorithmName + " input buffer too short");
        }
        if (len < 1) {
            return;
        }
        int available = 16 - this.m_bufPos;
        if (len <= available) {
            System.arraycopy(in, inOff, this.m_buf, this.m_bufPos, len);
            this.m_bufPos += len;
            return;
        }
        int inPos = 0;
        if (this.m_bufPos > 0) {
            System.arraycopy(in, inOff, this.m_buf, this.m_bufPos, available);
            this.processBlock(this.m_buf, 0, this.SPARKLE_STEPS_SLIM);
            inPos += available;
        }
        while ((remaining = len - inPos) > 16) {
            this.processBlock(in, inOff + inPos, this.SPARKLE_STEPS_SLIM);
            inPos += 16;
        }
        System.arraycopy(in, inOff + inPos, this.m_buf, 0, remaining);
        this.m_bufPos = remaining;
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        if (outOff > output.length - this.DIGEST_BYTES) {
            throw new OutputLengthException(this.algorithmName + " input buffer too short");
        }
        if (this.m_bufPos < 16) {
            int n = (this.STATE_WORDS >> 1) - 1;
            this.state[n] = this.state[n] ^ 0x1000000;
            this.m_buf[this.m_bufPos] = -128;
            while (++this.m_bufPos < 16) {
                this.m_buf[this.m_bufPos] = 0;
            }
        } else {
            int n = (this.STATE_WORDS >> 1) - 1;
            this.state[n] = this.state[n] ^ 0x2000000;
        }
        this.processBlock(this.m_buf, 0, this.SPARKLE_STEPS_BIG);
        Pack.intToLittleEndian(this.state, 0, 4, output, outOff);
        if (this.STATE_WORDS == 16) {
            SparkleEngine.sparkle_opt16(Friend.INSTANCE, this.state, this.SPARKLE_STEPS_SLIM);
            Pack.intToLittleEndian(this.state, 0, 4, output, outOff + 16);
            SparkleEngine.sparkle_opt16(Friend.INSTANCE, this.state, this.SPARKLE_STEPS_SLIM);
            Pack.intToLittleEndian(this.state, 0, 4, output, outOff + 32);
        } else {
            SparkleEngine.sparkle_opt12(Friend.INSTANCE, this.state, this.SPARKLE_STEPS_SLIM);
            Pack.intToLittleEndian(this.state, 0, 4, output, outOff + 16);
        }
        this.reset();
        return this.DIGEST_BYTES;
    }

    @Override
    public void reset() {
        Arrays.fill(this.state, 0);
        Arrays.fill(this.m_buf, (byte)0);
        this.m_bufPos = 0;
    }

    private void processBlock(byte[] buf, int off, int steps) {
        int t0 = Pack.littleEndianToInt(buf, off);
        int t1 = Pack.littleEndianToInt(buf, off + 4);
        int t2 = Pack.littleEndianToInt(buf, off + 8);
        int t3 = Pack.littleEndianToInt(buf, off + 12);
        int tx = SparkleDigest.ELL(t0 ^ t2);
        int ty = SparkleDigest.ELL(t1 ^ t3);
        this.state[0] = this.state[0] ^ (t0 ^ ty);
        this.state[1] = this.state[1] ^ (t1 ^ tx);
        this.state[2] = this.state[2] ^ (t2 ^ ty);
        this.state[3] = this.state[3] ^ (t3 ^ tx);
        this.state[4] = this.state[4] ^ ty;
        this.state[5] = this.state[5] ^ tx;
        if (this.STATE_WORDS == 16) {
            this.state[6] = this.state[6] ^ ty;
            this.state[7] = this.state[7] ^ tx;
            SparkleEngine.sparkle_opt16(Friend.INSTANCE, this.state, steps);
        } else {
            SparkleEngine.sparkle_opt12(Friend.INSTANCE, this.state, steps);
        }
    }

    private static int ELL(int x) {
        return Integers.rotateRight(x, 16) ^ x & 0xFFFF;
    }

    public static class Friend {
        private static final Friend INSTANCE = new Friend();

        private Friend() {
        }
    }

    public static enum SparkleParameters {
        ESCH256,
        ESCH384;

    }
}

