/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Pack;

public class ISAPEngine
implements AEADCipher {
    private String algorithmName;
    private boolean forEncryption;
    private boolean initialised;
    final int CRYPTO_KEYBYTES = 16;
    final int CRYPTO_NPUBBYTES = 16;
    final int ISAP_STATE_SZ = 40;
    private byte[] k;
    private byte[] c;
    private byte[] ad;
    private byte[] npub;
    private byte[] mac;
    private ByteArrayOutputStream aadData = new ByteArrayOutputStream();
    private final ByteArrayOutputStream message = new ByteArrayOutputStream();
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private int ISAP_rH;
    private int ISAP_rH_SZ;
    private ISAP_AEAD ISAPAEAD;

    public ISAPEngine(IsapType isapType) {
        switch (isapType.ordinal()) {
            case 0: {
                this.ISAPAEAD = new ISAPAEAD_A_128A();
                this.algorithmName = "ISAP-A-128A AEAD";
                break;
            }
            case 1: {
                this.ISAPAEAD = new ISAPAEAD_K_128A();
                this.algorithmName = "ISAP-K-128A AEAD";
                break;
            }
            case 2: {
                this.ISAPAEAD = new ISAPAEAD_A_128();
                this.algorithmName = "ISAP-A-128 AEAD";
                break;
            }
            case 3: {
                this.ISAPAEAD = new ISAPAEAD_K_128();
                this.algorithmName = "ISAP-K-128 AEAD";
            }
        }
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("ISAP AEAD init parameters must include an IV");
        }
        ParametersWithIV ivParams = (ParametersWithIV)params;
        byte[] iv = ivParams.getIV();
        if (iv == null || iv.length != 16) {
            throw new IllegalArgumentException("ISAP AEAD requires exactly 12 bytes of IV");
        }
        if (!(ivParams.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("ISAP AEAD init parameters must include a key");
        }
        KeyParameter key = (KeyParameter)ivParams.getParameters();
        byte[] keyBytes = key.getKey();
        if (keyBytes.length != 16) {
            throw new IllegalArgumentException("ISAP AEAD key must be 128 bits long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, Utils.getPurpose(forEncryption)));
        this.npub = new byte[iv.length];
        this.k = new byte[keyBytes.length];
        System.arraycopy(iv, 0, this.npub, 0, iv.length);
        System.arraycopy(keyBytes, 0, this.k, 0, keyBytes.length);
        this.ISAPAEAD.init();
        this.initialised = true;
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public void processAADByte(byte in) {
        this.aadData.write(in);
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short" + (this.forEncryption ? "encryption" : "decryption"));
        }
        this.aadData.write(in, inOff, len);
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{in}, 0, 1, out, outOff);
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.message.write(input, inOff, len);
        if (this.forEncryption && this.message.size() >= this.ISAP_rH_SZ) {
            len = this.message.size() / this.ISAP_rH_SZ * this.ISAP_rH_SZ;
            if (outOff + len > output.length) {
                throw new OutputLengthException("output buffer is too short");
            }
            byte[] enc_input = this.message.toByteArray();
            this.ISAPAEAD.isap_enc(enc_input, 0, len, output, outOff, output.length);
            this.outputStream.write(output, outOff, len);
            this.message.reset();
            this.message.write(enc_input, len, enc_input.length - len);
            return len;
        }
        return 0;
    }

    @Override
    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int len;
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        if (this.forEncryption) {
            byte[] enc_input = this.message.toByteArray();
            len = enc_input.length;
            if (outOff + len + 16 > output.length) {
                throw new OutputLengthException("output buffer is too short");
            }
            this.ISAPAEAD.isap_enc(enc_input, 0, len, output, outOff, output.length);
            this.outputStream.write(output, outOff, len);
            this.ad = this.aadData.toByteArray();
            this.c = this.outputStream.toByteArray();
            this.mac = new byte[16];
            this.ISAPAEAD.isap_mac(this.ad, this.ad.length, this.c, this.c.length, this.mac, 0);
            System.arraycopy(this.mac, 0, output, outOff += len, 16);
            len += 16;
        } else {
            this.ad = this.aadData.toByteArray();
            this.c = this.message.toByteArray();
            this.mac = new byte[16];
            len = this.c.length - this.mac.length;
            if (len + outOff > output.length) {
                throw new OutputLengthException("output buffer is too short");
            }
            this.ISAPAEAD.isap_mac(this.ad, this.ad.length, this.c, len, this.mac, 0);
            this.ISAPAEAD.reset();
            for (int i = 0; i < 16; ++i) {
                if (this.mac[i] == this.c[len + i]) continue;
                throw new IllegalArgumentException("Mac does not match");
            }
            this.ISAPAEAD.isap_enc(this.c, 0, len, output, outOff, output.length);
        }
        return len;
    }

    @Override
    public byte[] getMac() {
        return this.mac;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return len;
    }

    @Override
    public int getOutputSize(int len) {
        return len + 16;
    }

    @Override
    public void reset() {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        this.aadData.reset();
        this.ISAPAEAD.reset();
        this.message.reset();
        this.outputStream.reset();
    }

    public int getKeyBytesSize() {
        return 16;
    }

    public int getIVBytesSize() {
        return 16;
    }

    public int getBlockSize() {
        return this.ISAP_rH_SZ;
    }

    public abstract class ISAPAEAD_A
    implements ISAP_AEAD {
        protected long[] k64;
        protected long[] npub64;
        protected long ISAP_IV1_64;
        protected long ISAP_IV2_64;
        protected long ISAP_IV3_64;
        protected long x0;
        protected long x1;
        protected long x2;
        protected long x3;
        protected long x4;
        protected long t0;
        protected long t1;
        protected long t2;
        protected long t3;
        protected long t4;

        public ISAPAEAD_A() {
            ISAPEngine.this.ISAP_rH = 64;
            ISAPEngine.this.ISAP_rH_SZ = ISAPEngine.this.ISAP_rH + 7 >> 3;
        }

        @Override
        public void init() {
            this.npub64 = new long[this.getLongSize(ISAPEngine.this.npub.length)];
            Pack.littleEndianToLong(ISAPEngine.this.npub, 0, this.npub64, 0, this.npub64.length);
            this.npub64[0] = this.U64BIG(this.npub64[0]);
            this.npub64[1] = this.U64BIG(this.npub64[1]);
            this.k64 = new long[this.getLongSize(ISAPEngine.this.k.length)];
            Pack.littleEndianToLong(ISAPEngine.this.k, 0, this.k64, 0, this.k64.length);
            this.k64[0] = this.U64BIG(this.k64[0]);
            this.k64[1] = this.U64BIG(this.k64[1]);
            this.reset();
        }

        protected abstract void PX1();

        protected abstract void PX2();

        protected void ABSORB_MAC(byte[] src, int len) {
            long[] src64 = new long[src.length >> 3];
            Pack.littleEndianToLong(src, 0, src64, 0, src64.length);
            int idx = 0;
            while (len >= ISAPEngine.this.ISAP_rH_SZ) {
                this.x0 ^= this.U64BIG(src64[idx++]);
                this.P12();
                len -= ISAPEngine.this.ISAP_rH_SZ;
            }
            for (int i = 0; i < len; ++i) {
                this.x0 ^= ((long)src[(idx << 3) + i] & 0xFFL) << (7 - i << 3);
            }
            this.x0 ^= 128L << (7 - len << 3);
            this.P12();
        }

        @Override
        public void isap_mac(byte[] ad, int adlen, byte[] c, int clen, byte[] tag, int tagOff) {
            this.x0 = this.npub64[0];
            this.x1 = this.npub64[1];
            this.x2 = this.ISAP_IV1_64;
            this.x4 = 0L;
            this.x3 = 0L;
            this.P12();
            this.ABSORB_MAC(ad, adlen);
            this.x4 ^= 1L;
            this.ABSORB_MAC(c, clen);
            Pack.longToLittleEndian(this.U64BIG(this.x0), tag, 0);
            Pack.longToLittleEndian(this.U64BIG(this.x1), tag, 8);
            long tmp_x2 = this.x2;
            long tmp_x3 = this.x3;
            long tmp_x4 = this.x4;
            this.isap_rk(this.ISAP_IV2_64, tag, 16);
            this.x2 = tmp_x2;
            this.x3 = tmp_x3;
            this.x4 = tmp_x4;
            this.P12();
            Pack.longToLittleEndian(this.U64BIG(this.x0), tag, tagOff);
            Pack.longToLittleEndian(this.U64BIG(this.x1), tag, tagOff + 8);
        }

        public void isap_rk(long iv64, byte[] y, int ylen) {
            this.x0 = this.k64[0];
            this.x1 = this.k64[1];
            this.x2 = iv64;
            this.x4 = 0L;
            this.x3 = 0L;
            this.P12();
            for (int i = 0; i < (ylen << 3) - 1; ++i) {
                this.x0 ^= ((long)((y[i >>> 3] >>> 7 - (i & 7) & 1) << 7) & 0xFFL) << 56;
                this.PX2();
            }
            this.x0 ^= ((long)y[ylen - 1] & 1L) << 7 << 56;
            this.P12();
        }

        @Override
        public void isap_enc(byte[] m, int mOff, int mlen, byte[] c, int cOff, int clen) {
            long[] m64 = new long[mlen >> 3];
            Pack.littleEndianToLong(m, mOff, m64, 0, m64.length);
            long[] c64 = new long[m64.length];
            int idx = 0;
            while (mlen >= ISAPEngine.this.ISAP_rH_SZ) {
                c64[idx] = this.U64BIG(this.x0) ^ m64[idx];
                this.PX1();
                ++idx;
                mlen -= ISAPEngine.this.ISAP_rH_SZ;
            }
            Pack.longToLittleEndian(c64, 0, c64.length, c, cOff);
            byte[] xo = Pack.longToLittleEndian(this.x0);
            while (mlen > 0) {
                c[(idx << 3) + cOff + mlen - 1] = (byte)(xo[ISAPEngine.this.ISAP_rH_SZ - mlen] ^ m[(idx << 3) + mOff + --mlen]);
            }
        }

        @Override
        public void reset() {
            this.isap_rk(this.ISAP_IV3_64, ISAPEngine.this.npub, 16);
            this.x3 = this.npub64[0];
            this.x4 = this.npub64[1];
            this.PX1();
        }

        private int getLongSize(int x) {
            return (x >>> 3) + ((x & 7) != 0 ? 1 : 0);
        }

        private long ROTR(long x, long n) {
            return x >>> (int)n | x << (int)(64L - n);
        }

        protected long U64BIG(long x) {
            return this.ROTR(x, 8L) & 0xFF000000FF000000L | this.ROTR(x, 24L) & 0xFF000000FF0000L | this.ROTR(x, 40L) & 0xFF000000FF00L | this.ROTR(x, 56L) & 0xFF000000FFL;
        }

        protected void ROUND(long C) {
            this.t0 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ C ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ C);
            this.t1 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ C ^ (this.x1 ^ this.x2 ^ C) & (this.x1 ^ this.x3);
            this.t2 = this.x1 ^ this.x2 ^ this.x4 ^ C ^ this.x3 & this.x4;
            this.t3 = this.x0 ^ this.x1 ^ this.x2 ^ C ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
            this.t4 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
            this.x0 = this.t0 ^ this.ROTR(this.t0, 19L) ^ this.ROTR(this.t0, 28L);
            this.x1 = this.t1 ^ this.ROTR(this.t1, 39L) ^ this.ROTR(this.t1, 61L);
            this.x2 = this.t2 ^ this.ROTR(this.t2, 1L) ^ this.ROTR(this.t2, 6L) ^ 0xFFFFFFFFFFFFFFFFL;
            this.x3 = this.t3 ^ this.ROTR(this.t3, 10L) ^ this.ROTR(this.t3, 17L);
            this.x4 = this.t4 ^ this.ROTR(this.t4, 7L) ^ this.ROTR(this.t4, 41L);
        }

        public void P12() {
            this.ROUND(240L);
            this.ROUND(225L);
            this.ROUND(210L);
            this.ROUND(195L);
            this.ROUND(180L);
            this.ROUND(165L);
            this.P6();
        }

        protected void P6() {
            this.ROUND(150L);
            this.ROUND(135L);
            this.ROUND(120L);
            this.ROUND(105L);
            this.ROUND(90L);
            this.ROUND(75L);
        }
    }

    private class ISAPAEAD_A_128
    extends ISAPAEAD_A {
        public ISAPAEAD_A_128() {
            this.ISAP_IV1_64 = 108156764298152972L;
            this.ISAP_IV2_64 = 180214358336080908L;
            this.ISAP_IV3_64 = 252271952374008844L;
        }

        @Override
        protected void PX1() {
            this.P12();
        }

        @Override
        protected void PX2() {
            this.P12();
        }
    }

    private class ISAPAEAD_A_128A
    extends ISAPAEAD_A {
        public ISAPAEAD_A_128A() {
            this.ISAP_IV1_64 = 108156764297430540L;
            this.ISAP_IV2_64 = 180214358335358476L;
            this.ISAP_IV3_64 = 252271952373286412L;
        }

        @Override
        protected void PX1() {
            this.P6();
        }

        @Override
        protected void PX2() {
            this.ROUND(75L);
        }
    }

    private abstract class ISAPAEAD_K
    implements ISAP_AEAD {
        final int ISAP_STATE_SZ_CRYPTO_NPUBBYTES = 24;
        protected short[] ISAP_IV1_16;
        protected short[] ISAP_IV2_16;
        protected short[] ISAP_IV3_16;
        protected short[] k16;
        protected short[] iv16;
        private final int[] KeccakF400RoundConstants = new int[]{1, 32898, 32906, 32768, 32907, 1, 32897, 32777, 138, 136, 32777, 10, 32907, 139, 32905, 32771, 32770, 128, 32778, 10};
        protected short[] SX = new short[25];
        protected short[] E = new short[25];
        protected short[] C = new short[5];

        public ISAPAEAD_K() {
            ISAPEngine.this.ISAP_rH = 144;
            ISAPEngine.this.ISAP_rH_SZ = ISAPEngine.this.ISAP_rH + 7 >> 3;
        }

        @Override
        public void init() {
            this.k16 = new short[ISAPEngine.this.k.length >> 1];
            this.byteToShort(ISAPEngine.this.k, this.k16, this.k16.length);
            this.iv16 = new short[ISAPEngine.this.npub.length >> 1];
            this.byteToShort(ISAPEngine.this.npub, this.iv16, this.iv16.length);
            this.reset();
        }

        @Override
        public void reset() {
            this.SX = new short[25];
            this.E = new short[25];
            this.C = new short[5];
            this.isap_rk(this.ISAP_IV3_16, ISAPEngine.this.npub, 16, this.SX, 24, this.C);
            System.arraycopy(this.iv16, 0, this.SX, 17, 8);
            this.PermuteRoundsKX(this.SX, this.E, this.C);
        }

        protected abstract void PermuteRoundsHX(short[] var1, short[] var2, short[] var3);

        protected abstract void PermuteRoundsKX(short[] var1, short[] var2, short[] var3);

        protected abstract void PermuteRoundsBX(short[] var1, short[] var2, short[] var3);

        protected void ABSORB_MAC(short[] SX, byte[] src, int len, short[] E, short[] C) {
            int rem_bytes;
            int idx = 0;
            for (rem_bytes = len; rem_bytes > ISAPEngine.this.ISAP_rH_SZ; rem_bytes -= ISAPEngine.this.ISAP_rH_SZ) {
                this.byteToShortXor(src, SX, ISAPEngine.this.ISAP_rH_SZ >> 1);
                idx += ISAPEngine.this.ISAP_rH_SZ;
                this.PermuteRoundsHX(SX, E, C);
            }
            if (rem_bytes == ISAPEngine.this.ISAP_rH_SZ) {
                this.byteToShortXor(src, SX, ISAPEngine.this.ISAP_rH_SZ >> 1);
                this.PermuteRoundsHX(SX, E, C);
                SX[0] = (short)(SX[0] ^ 0x80);
                this.PermuteRoundsHX(SX, E, C);
            } else {
                for (int i = 0; i < rem_bytes; ++i) {
                    int n = i >> 1;
                    SX[n] = (short)(SX[n] ^ (src[idx++] & 0xFF) << ((i & 1) << 3));
                }
                int n = rem_bytes >> 1;
                SX[n] = (short)(SX[n] ^ 128 << ((rem_bytes & 1) << 3));
                this.PermuteRoundsHX(SX, E, C);
            }
        }

        public void isap_rk(short[] iv16, byte[] y, int ylen, short[] out16, int outlen, short[] C) {
            short[] SX = new short[25];
            short[] E = new short[25];
            System.arraycopy(this.k16, 0, SX, 0, 8);
            System.arraycopy(iv16, 0, SX, 8, 4);
            this.PermuteRoundsKX(SX, E, C);
            for (int i = 0; i < (ylen << 3) - 1; ++i) {
                SX[0] = (short)(SX[0] ^ (y[i >> 3] >>> 7 - (i & 7) & 1) << 7);
                this.PermuteRoundsBX(SX, E, C);
            }
            SX[0] = (short)(SX[0] ^ (y[ylen - 1] & 1) << 7);
            this.PermuteRoundsKX(SX, E, C);
            System.arraycopy(SX, 0, out16, 0, outlen == 24 ? 17 : 8);
        }

        @Override
        public void isap_mac(byte[] ad, int adlen, byte[] c, int clen, byte[] tag, int tagOff) {
            this.SX = new short[25];
            System.arraycopy(this.iv16, 0, this.SX, 0, 8);
            System.arraycopy(this.ISAP_IV1_16, 0, this.SX, 8, 4);
            this.PermuteRoundsHX(this.SX, this.E, this.C);
            this.ABSORB_MAC(this.SX, ad, adlen, this.E, this.C);
            this.SX[24] = (short)(this.SX[24] ^ 0x100);
            this.ABSORB_MAC(this.SX, c, clen, this.E, this.C);
            this.shortToByte(this.SX, tag, tagOff);
            this.isap_rk(this.ISAP_IV2_16, tag, 16, this.SX, 16, this.C);
            this.PermuteRoundsHX(this.SX, this.E, this.C);
            this.shortToByte(this.SX, tag, tagOff);
        }

        @Override
        public void isap_enc(byte[] m, int mOff, int mlen, byte[] c, int cOff, int clen) {
            int i;
            while (mlen >= ISAPEngine.this.ISAP_rH_SZ) {
                for (i = 0; i < ISAPEngine.this.ISAP_rH_SZ; ++i) {
                    c[cOff++] = (byte)(this.SX[i >> 1] >>> ((i & 1) << 3) ^ m[mOff++]);
                }
                mlen -= ISAPEngine.this.ISAP_rH_SZ;
                this.PermuteRoundsKX(this.SX, this.E, this.C);
            }
            for (i = 0; i < mlen; ++i) {
                c[cOff++] = (byte)(this.SX[i >> 1] >>> ((i & 1) << 3) ^ m[mOff++]);
            }
        }

        private void byteToShortXor(byte[] input, short[] output, int outLen) {
            for (int i = 0; i < outLen; ++i) {
                int n = i;
                output[n] = (short)(output[n] ^ Pack.littleEndianToShort(input, i << 1));
            }
        }

        private void byteToShort(byte[] input, short[] output, int outLen) {
            for (int i = 0; i < outLen; ++i) {
                output[i] = Pack.littleEndianToShort(input, i << 1);
            }
        }

        private void shortToByte(short[] input, byte[] output, int outOff) {
            for (int i = 0; i < 8; ++i) {
                Pack.shortToLittleEndian(input[i], output, outOff + (i << 1));
            }
        }

        protected void rounds12X(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.rounds_8_18(SX, E, C);
        }

        protected void rounds_4_18(short[] SX, short[] E, short[] C) {
            this.thetaRhoPiChiIotaPrepareTheta(4, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(5, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(6, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(7, E, SX, C);
            this.rounds_8_18(SX, E, C);
        }

        protected void rounds_8_18(short[] SX, short[] E, short[] C) {
            this.thetaRhoPiChiIotaPrepareTheta(8, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(9, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(10, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(11, E, SX, C);
            this.rounds_12_18(SX, E, C);
        }

        protected void rounds_12_18(short[] SX, short[] E, short[] C) {
            this.thetaRhoPiChiIotaPrepareTheta(12, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(13, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(14, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(15, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(16, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(17, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(18, SX, E, C);
            this.thetaRhoPiChiIota(E, SX, C);
        }

        protected void prepareThetaX(short[] SX, short[] C) {
            C[0] = (short)(SX[0] ^ SX[5] ^ SX[10] ^ SX[15] ^ SX[20]);
            C[1] = (short)(SX[1] ^ SX[6] ^ SX[11] ^ SX[16] ^ SX[21]);
            C[2] = (short)(SX[2] ^ SX[7] ^ SX[12] ^ SX[17] ^ SX[22]);
            C[3] = (short)(SX[3] ^ SX[8] ^ SX[13] ^ SX[18] ^ SX[23]);
            C[4] = (short)(SX[4] ^ SX[9] ^ SX[14] ^ SX[19] ^ SX[24]);
        }

        private short ROL16(short a, int offset) {
            return (short)((a & 0xFFFF) << offset ^ (a & 0xFFFF) >>> 16 - offset);
        }

        protected void thetaRhoPiChiIotaPrepareTheta(int i, short[] A, short[] E, short[] C) {
            short Da = (short)(C[4] ^ this.ROL16(C[1], 1));
            short De = (short)(C[0] ^ this.ROL16(C[2], 1));
            short Di = (short)(C[1] ^ this.ROL16(C[3], 1));
            short Do = (short)(C[2] ^ this.ROL16(C[4], 1));
            short Du = (short)(C[3] ^ this.ROL16(C[0], 1));
            short Ba = A[0] = (short)(A[0] ^ Da);
            A[6] = (short)(A[6] ^ De);
            short Be = this.ROL16(A[6], 12);
            A[12] = (short)(A[12] ^ Di);
            short Bi = this.ROL16(A[12], 11);
            A[18] = (short)(A[18] ^ Do);
            short Bo = this.ROL16(A[18], 5);
            A[24] = (short)(A[24] ^ Du);
            short Bu = this.ROL16(A[24], 14);
            C[0] = E[0] = (short)(Ba ^ ~Be & Bi ^ this.KeccakF400RoundConstants[i]);
            C[1] = E[1] = (short)(Be ^ ~Bi & Bo);
            C[2] = E[2] = (short)(Bi ^ ~Bo & Bu);
            C[3] = E[3] = (short)(Bo ^ ~Bu & Ba);
            C[4] = E[4] = (short)(Bu ^ ~Ba & Be);
            A[3] = (short)(A[3] ^ Do);
            Ba = this.ROL16(A[3], 12);
            A[9] = (short)(A[9] ^ Du);
            Be = this.ROL16(A[9], 4);
            A[10] = (short)(A[10] ^ Da);
            Bi = this.ROL16(A[10], 3);
            A[16] = (short)(A[16] ^ De);
            Bo = this.ROL16(A[16], 13);
            A[22] = (short)(A[22] ^ Di);
            Bu = this.ROL16(A[22], 13);
            E[5] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[5]);
            E[6] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[6]);
            E[7] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[7]);
            E[8] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[8]);
            E[9] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[9]);
            A[1] = (short)(A[1] ^ De);
            Ba = this.ROL16(A[1], 1);
            A[7] = (short)(A[7] ^ Di);
            Be = this.ROL16(A[7], 6);
            A[13] = (short)(A[13] ^ Do);
            Bi = this.ROL16(A[13], 9);
            A[19] = (short)(A[19] ^ Du);
            Bo = this.ROL16(A[19], 8);
            A[20] = (short)(A[20] ^ Da);
            Bu = this.ROL16(A[20], 2);
            E[10] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[10]);
            E[11] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[11]);
            E[12] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[12]);
            E[13] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[13]);
            E[14] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[14]);
            A[4] = (short)(A[4] ^ Du);
            Ba = this.ROL16(A[4], 11);
            A[5] = (short)(A[5] ^ Da);
            Be = this.ROL16(A[5], 4);
            A[11] = (short)(A[11] ^ De);
            Bi = this.ROL16(A[11], 10);
            A[17] = (short)(A[17] ^ Di);
            Bo = this.ROL16(A[17], 15);
            A[23] = (short)(A[23] ^ Do);
            Bu = this.ROL16(A[23], 8);
            E[15] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[15]);
            E[16] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[16]);
            E[17] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[17]);
            E[18] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[18]);
            E[19] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[19]);
            A[2] = (short)(A[2] ^ Di);
            Ba = this.ROL16(A[2], 14);
            A[8] = (short)(A[8] ^ Do);
            Be = this.ROL16(A[8], 7);
            A[14] = (short)(A[14] ^ Du);
            Bi = this.ROL16(A[14], 7);
            A[15] = (short)(A[15] ^ Da);
            Bo = this.ROL16(A[15], 9);
            A[21] = (short)(A[21] ^ De);
            Bu = this.ROL16(A[21], 2);
            E[20] = (short)(Ba ^ ~Be & Bi);
            C[0] = (short)(C[0] ^ E[20]);
            E[21] = (short)(Be ^ ~Bi & Bo);
            C[1] = (short)(C[1] ^ E[21]);
            E[22] = (short)(Bi ^ ~Bo & Bu);
            C[2] = (short)(C[2] ^ E[22]);
            E[23] = (short)(Bo ^ ~Bu & Ba);
            C[3] = (short)(C[3] ^ E[23]);
            E[24] = (short)(Bu ^ ~Ba & Be);
            C[4] = (short)(C[4] ^ E[24]);
        }

        protected void thetaRhoPiChiIota(short[] A, short[] E, short[] C) {
            short Da = (short)(C[4] ^ this.ROL16(C[1], 1));
            short De = (short)(C[0] ^ this.ROL16(C[2], 1));
            short Di = (short)(C[1] ^ this.ROL16(C[3], 1));
            short Do = (short)(C[2] ^ this.ROL16(C[4], 1));
            short Du = (short)(C[3] ^ this.ROL16(C[0], 1));
            short Ba = A[0] = (short)(A[0] ^ Da);
            A[6] = (short)(A[6] ^ De);
            short Be = this.ROL16(A[6], 12);
            A[12] = (short)(A[12] ^ Di);
            short Bi = this.ROL16(A[12], 11);
            A[18] = (short)(A[18] ^ Do);
            short Bo = this.ROL16(A[18], 5);
            A[24] = (short)(A[24] ^ Du);
            short Bu = this.ROL16(A[24], 14);
            E[0] = (short)(Ba ^ ~Be & Bi ^ this.KeccakF400RoundConstants[19]);
            E[1] = (short)(Be ^ ~Bi & Bo);
            E[2] = (short)(Bi ^ ~Bo & Bu);
            E[3] = (short)(Bo ^ ~Bu & Ba);
            E[4] = (short)(Bu ^ ~Ba & Be);
            A[3] = (short)(A[3] ^ Do);
            Ba = this.ROL16(A[3], 12);
            A[9] = (short)(A[9] ^ Du);
            Be = this.ROL16(A[9], 4);
            A[10] = (short)(A[10] ^ Da);
            Bi = this.ROL16(A[10], 3);
            A[16] = (short)(A[16] ^ De);
            Bo = this.ROL16(A[16], 13);
            A[22] = (short)(A[22] ^ Di);
            Bu = this.ROL16(A[22], 13);
            E[5] = (short)(Ba ^ ~Be & Bi);
            E[6] = (short)(Be ^ ~Bi & Bo);
            E[7] = (short)(Bi ^ ~Bo & Bu);
            E[8] = (short)(Bo ^ ~Bu & Ba);
            E[9] = (short)(Bu ^ ~Ba & Be);
            A[1] = (short)(A[1] ^ De);
            Ba = this.ROL16(A[1], 1);
            A[7] = (short)(A[7] ^ Di);
            Be = this.ROL16(A[7], 6);
            A[13] = (short)(A[13] ^ Do);
            Bi = this.ROL16(A[13], 9);
            A[19] = (short)(A[19] ^ Du);
            Bo = this.ROL16(A[19], 8);
            A[20] = (short)(A[20] ^ Da);
            Bu = this.ROL16(A[20], 2);
            E[10] = (short)(Ba ^ ~Be & Bi);
            E[11] = (short)(Be ^ ~Bi & Bo);
            E[12] = (short)(Bi ^ ~Bo & Bu);
            E[13] = (short)(Bo ^ ~Bu & Ba);
            E[14] = (short)(Bu ^ ~Ba & Be);
            A[4] = (short)(A[4] ^ Du);
            Ba = this.ROL16(A[4], 11);
            A[5] = (short)(A[5] ^ Da);
            Be = this.ROL16(A[5], 4);
            A[11] = (short)(A[11] ^ De);
            Bi = this.ROL16(A[11], 10);
            A[17] = (short)(A[17] ^ Di);
            Bo = this.ROL16(A[17], 15);
            A[23] = (short)(A[23] ^ Do);
            Bu = this.ROL16(A[23], 8);
            E[15] = (short)(Ba ^ ~Be & Bi);
            E[16] = (short)(Be ^ ~Bi & Bo);
            E[17] = (short)(Bi ^ ~Bo & Bu);
            E[18] = (short)(Bo ^ ~Bu & Ba);
            E[19] = (short)(Bu ^ ~Ba & Be);
            A[2] = (short)(A[2] ^ Di);
            Ba = this.ROL16(A[2], 14);
            A[8] = (short)(A[8] ^ Do);
            Be = this.ROL16(A[8], 7);
            A[14] = (short)(A[14] ^ Du);
            Bi = this.ROL16(A[14], 7);
            A[15] = (short)(A[15] ^ Da);
            Bo = this.ROL16(A[15], 9);
            A[21] = (short)(A[21] ^ De);
            Bu = this.ROL16(A[21], 2);
            E[20] = (short)(Ba ^ ~Be & Bi);
            E[21] = (short)(Be ^ ~Bi & Bo);
            E[22] = (short)(Bi ^ ~Bo & Bu);
            E[23] = (short)(Bo ^ ~Bu & Ba);
            E[24] = (short)(Bu ^ ~Ba & Be);
        }
    }

    private class ISAPAEAD_K_128
    extends ISAPAEAD_K {
        public ISAPAEAD_K_128() {
            this.ISAP_IV1_16 = new short[]{-32767, 400, 3092, 3084};
            this.ISAP_IV2_16 = new short[]{-32766, 400, 3092, 3084};
            this.ISAP_IV3_16 = new short[]{-32765, 400, 3092, 3084};
        }

        @Override
        protected void PermuteRoundsHX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(0, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(1, E, SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(2, SX, E, C);
            this.thetaRhoPiChiIotaPrepareTheta(3, E, SX, C);
            this.rounds_4_18(SX, E, C);
        }

        @Override
        protected void PermuteRoundsKX(short[] SX, short[] E, short[] C) {
            this.rounds12X(SX, E, C);
        }

        @Override
        protected void PermuteRoundsBX(short[] SX, short[] E, short[] C) {
            this.rounds12X(SX, E, C);
        }
    }

    private class ISAPAEAD_K_128A
    extends ISAPAEAD_K {
        public ISAPAEAD_K_128A() {
            this.ISAP_IV1_16 = new short[]{-32767, 400, 272, 2056};
            this.ISAP_IV2_16 = new short[]{-32766, 400, 272, 2056};
            this.ISAP_IV3_16 = new short[]{-32765, 400, 272, 2056};
        }

        @Override
        protected void PermuteRoundsHX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.rounds_4_18(SX, E, C);
        }

        @Override
        protected void PermuteRoundsKX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.rounds_12_18(SX, E, C);
        }

        @Override
        protected void PermuteRoundsBX(short[] SX, short[] E, short[] C) {
            this.prepareThetaX(SX, C);
            this.thetaRhoPiChiIotaPrepareTheta(19, SX, E, C);
            System.arraycopy(E, 0, SX, 0, E.length);
        }
    }

    private static interface ISAP_AEAD {
        public void isap_enc(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

        public void init();

        public void isap_mac(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

        public void reset();
    }

    public static enum IsapType {
        ISAP_A_128A,
        ISAP_K_128A,
        ISAP_A_128,
        ISAP_K_128;

    }
}

