/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.ec;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class AlgorithmParametersSpi
extends java.security.AlgorithmParametersSpi {
    private ECParameterSpec ecParameterSpec;
    private String curveName;

    protected boolean isASN1FormatString(String string) {
        return string == null || string.equals("ASN.1");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec) {
            ECNamedCurveGenParameterSpec eCNamedCurveGenParameterSpec = (ECNamedCurveGenParameterSpec)algorithmParameterSpec;
            X9ECParameters x9ECParameters = ECNamedCurveTable.getByName(eCNamedCurveGenParameterSpec.getName());
            this.curveName = eCNamedCurveGenParameterSpec.getName();
            this.ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        } else if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.curveName = null;
            this.ecParameterSpec = (ECParameterSpec)algorithmParameterSpec;
        } else {
            throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + algorithmParameterSpec.getClass().getName());
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        this.engineInit(byArray, "ASN.1");
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        X962Parameters x962Parameters;
        if (this.isASN1FormatString(string)) {
            x962Parameters = X962Parameters.getInstance(byArray);
            if (x962Parameters.isNamedCurve()) {
                this.curveName = ECNamedCurveTable.getName(ASN1ObjectIdentifier.getInstance(x962Parameters.getParameters()));
                X9ECParameters x9ECParameters = ECNamedCurveTable.getByName(this.curveName);
                this.ecParameterSpec = new ECNamedCurveParameterSpec(this.curveName, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
                return;
            }
        } else {
            throw new IOException("Unknown encoded parameters format in AlgorithmParameters object: " + string);
        }
        X9ECParameters x9ECParameters = X9ECParameters.getInstance(x962Parameters.getParameters());
        this.ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (ECParameterSpec.class.isAssignableFrom(clazz) || clazz == AlgorithmParameterSpec.class) {
            return this.ecParameterSpec;
        }
        if (ECNamedCurveGenParameterSpec.class.isAssignableFrom(clazz) && this.curveName != null) {
            return new ECNamedCurveGenParameterSpec(this.curveName);
        }
        throw new InvalidParameterSpecException("EC AlgorithmParameters cannot convert to " + clazz.getName());
    }

    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            X962Parameters x962Parameters;
            if (this.ecParameterSpec == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else if (this.curveName != null) {
                x962Parameters = new X962Parameters(ECNamedCurveTable.getOID(this.curveName));
            } else {
                X9ECParameters x9ECParameters = new X9ECParameters(this.ecParameterSpec.getCurve(), new X9ECPoint(this.ecParameterSpec.getG(), false), this.ecParameterSpec.getN(), this.ecParameterSpec.getH(), this.ecParameterSpec.getSeed());
                x962Parameters = new X962Parameters(x9ECParameters);
            }
            return x962Parameters.getEncoded();
        }
        throw new IOException("Unknown parameters format in AlgorithmParameters object: " + string);
    }

    protected String engineToString() {
        return "EC Parameters";
    }
}

