/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.modes.AESCBCModePacketCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESNativeCBCPacketCipher
implements PacketCipher,
AESCBCModePacketCipher {
    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        try {
            this.checkParameters(cipherParameters);
        }
        catch (PacketCipherException packetCipherException) {
            packetCipherException.throwCauseAsRuntimeException();
        }
        return AESNativeCBCPacketCipher.getOutputSize(n);
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        int n4;
        byte[] byArray3;
        byte[] byArray4;
        try {
            KeyParameter keyParameter;
            if (cipherParameters instanceof ParametersWithIV) {
                ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
                byArray4 = (byte[])parametersWithIV.getIV().clone();
                keyParameter = (KeyParameter)parametersWithIV.getParameters();
                if (keyParameter == null) {
                    throw new IllegalArgumentException("CBC cipher unitialized");
                }
            } else {
                throw new IllegalArgumentException("invalid parameter type");
            }
            byArray3 = keyParameter.getKey();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PacketCipherException.from(illegalArgumentException);
        }
        int n5 = byArray2 != null ? byArray2.length - n3 : 0;
        try {
            n4 = AESNativeCBCPacketCipher.processPacket(bl, byArray3, byArray4, byArray, n, n2, byArray2, n3, n5);
        }
        catch (Exception exception) {
            throw PacketCipherException.from(exception);
        }
        return n4;
    }

    static native int getOutputSize(int var0);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    public String toString() {
        return "CBC-PS[Native](AES[Native])";
    }
}

