/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CCMModeCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class AESNativeCCM
implements CCMModeCipher {
    private CCMRefWrapper refWrapper;
    private boolean forEncryption = false;
    private boolean initialised = false;
    private final ExposedByteArrayOutputStream associatedText = new ExposedByteArrayOutputStream();
    private final ExposedByteArrayOutputStream data = new ExposedByteArrayOutputStream();

    AESNativeCCM() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockCipher getUnderlyingCipher() {
        AESNativeCCM aESNativeCCM = this;
        synchronized (aESNativeCCM) {
            MultiBlockCipher multiBlockCipher = AESEngine.newInstance();
            if (this.refWrapper != null && this.refWrapper.key != null) {
                multiBlockCipher.init(true, new KeyParameter(this.refWrapper.key));
            }
            return multiBlockCipher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        AESNativeCCM aESNativeCCM = this;
        synchronized (aESNativeCCM) {
            CipherParameters cipherParameters2;
            int n;
            byte[] byArray;
            byte[] byArray2;
            Object object;
            this.forEncryption = bl;
            CipherParameters cipherParameters3 = null;
            if (cipherParameters instanceof AEADParameters) {
                object = (AEADParameters)cipherParameters;
                byArray2 = ((AEADParameters)object).getNonce();
                byArray = ((AEADParameters)object).getAssociatedText();
                n = this.getMacSize(bl, ((AEADParameters)object).getMacSize());
                cipherParameters2 = ((AEADParameters)object).getKey();
            } else if (cipherParameters instanceof ParametersWithIV) {
                object = (ParametersWithIV)cipherParameters;
                byArray2 = ((ParametersWithIV)object).getIV();
                byArray = null;
                n = this.getMacSize(bl, 64);
                cipherParameters2 = ((ParametersWithIV)object).getParameters();
            } else {
                throw new IllegalArgumentException("invalid parameters passed to CCM");
            }
            if (cipherParameters2 != null) {
                cipherParameters3 = cipherParameters2;
            }
            if (cipherParameters3 != null) {
                object = ((KeyParameter)cipherParameters3).getKey();
                if (object == null) {
                    throw new IllegalArgumentException("key was null");
                }
                this.initRef((byte[])object);
            }
            assert (this.refWrapper != null);
            int n2 = byArray != null ? byArray.length : 0;
            AESNativeCCM.initNative(this.refWrapper.getReference(), bl, this.refWrapper.key, byArray2, byArray, n2, n * 8);
            this.reset();
            this.initialised = true;
        }
    }

    private void initRef(byte[] byArray) {
        this.refWrapper = new CCMRefWrapper(AESNativeCCM.makeInstance(), Arrays.clone(byArray));
    }

    @Override
    public String getAlgorithmName() {
        return "AES/CCM";
    }

    @Override
    public void processAADByte(byte by) {
        this.associatedText.write(by);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("offset is negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len is negative");
        }
        if (byArray.length < n + n2) {
            throw new IllegalArgumentException("array too short for offset + len");
        }
        this.associatedText.write(byArray, n, n2);
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
        if (n < 0) {
            throw new IllegalArgumentException("offset is negative");
        }
        if (byArray != null && byArray.length < n) {
            throw new DataLengthException("offset past end");
        }
        this.data.write(by);
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (n < 0 || n3 < 0) {
            throw new IllegalArgumentException("offset is negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len is negative");
        }
        if (byArray == null) {
            throw new NullPointerException("input was null");
        }
        if (byArray.length < n + n2) {
            throw new DataLengthException("array too short for offset + len");
        }
        this.data.write(byArray, n, n2);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException {
        AESNativeCCM aESNativeCCM = this;
        synchronized (aESNativeCCM) {
            int n2;
            try {
                this.checkStatus();
                if (byArray == null) {
                    throw new NullPointerException("output was null");
                }
                if (n < 0) {
                    throw new IllegalArgumentException("offset is negative");
                }
                if (this.getOutputSize(0) > byArray.length - n) {
                    throw new OutputLengthException("output buffer too short");
                }
                n2 = AESNativeCCM.processPacket(this.refWrapper.getReference(), this.data.getBuffer(), 0, this.data.size(), this.associatedText.getBuffer(), 0, this.associatedText.size(), byArray, n);
                this.resetKeepMac();
            }
            catch (IllegalStateException illegalStateException) {
                this.reset();
                throw illegalStateException;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getMac() {
        AESNativeCCM aESNativeCCM = this;
        synchronized (aESNativeCCM) {
            return AESNativeCCM.getMac(this.refWrapper.getReference());
        }
    }

    @Override
    public int getUpdateOutputSize(int n) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOutputSize(int n) {
        AESNativeCCM aESNativeCCM = this;
        synchronized (aESNativeCCM) {
            return AESNativeCCM.getOutputSize(this.refWrapper.getReference(), n + this.data.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AESNativeCCM aESNativeCCM = this;
        synchronized (aESNativeCCM) {
            if (this.refWrapper == null) {
                return;
            }
            this.associatedText.reset();
            this.data.reset();
            this.reset(this.refWrapper.getReference(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetKeepMac() {
        AESNativeCCM aESNativeCCM = this;
        synchronized (aESNativeCCM) {
            if (this.refWrapper == null) {
                return;
            }
            this.associatedText.reset();
            this.data.reset();
            this.reset(this.refWrapper.getReference(), true);
        }
    }

    private void checkStatus() {
        if (!this.initialised) {
            if (this.forEncryption) {
                throw new IllegalStateException("CCM cipher cannot be reused for encryption");
            }
            throw new IllegalStateException("CCM cipher needs to be initialised");
        }
    }

    private native void reset(long var1, boolean var3);

    static native void initNative(long var0, boolean var2, byte[] var3, byte[] var4, byte[] var5, int var6, int var7);

    static native long makeInstance();

    static native void dispose(long var0);

    static native int getOutputSize(long var0, int var2);

    static native byte[] getMac(long var0);

    static native int processPacket(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7, byte[] var8, int var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processPacket(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws InvalidCipherTextException {
        AESNativeCCM aESNativeCCM = this;
        synchronized (aESNativeCCM) {
            int n4 = AESNativeCCM.processPacket(this.refWrapper.getReference(), byArray, n, n2, this.associatedText.getBuffer(), 0, this.associatedText.size(), byArray2, n3);
            this.reset();
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] processPacket(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        AESNativeCCM aESNativeCCM = this;
        synchronized (aESNativeCCM) {
            byte[] byArray2 = new byte[this.getOutputSize(n2)];
            this.processPacket(byArray, n, n2, byArray2, 0);
            this.reset();
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        AESNativeCCM aESNativeCCM = this;
        synchronized (aESNativeCCM) {
            if (this.refWrapper != null && this.refWrapper.key != null) {
                return "CCM[Native](AES[Native](" + this.refWrapper.key.length * 8 + "))";
            }
            return "CCM[Native](AES[Native](not initialized))";
        }
    }

    private int getMacSize(boolean bl, int n) {
        if (bl && (n < 32 || n > 128 || 0 != (n & 0xF))) {
            throw new IllegalArgumentException("invalid value for MAC size");
        }
        return n >>> 3;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class CCMRefWrapper
    extends NativeReference {
        private final byte[] key;

        public CCMRefWrapper(long l, byte[] byArray) {
            super(l, "CCM");
            this.key = byArray;
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference, this.key);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        private final byte[] key;

        public Disposer(long l, byte[] byArray) {
            super(l);
            this.key = byArray;
        }

        @Override
        protected void dispose(long l) {
            Arrays.clear(this.key);
            AESNativeCCM.dispose(l);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

