/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ImportX509TrustManager;
import org.bouncycastle.jsse.provider.ProvAlgorithmChecker;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;
import org.bouncycastle.jsse.provider.TransportData;
import org.bouncycastle.tls.TlsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ImportX509TrustManager_5
extends BCX509ExtendedTrustManager
implements ImportX509TrustManager {
    final boolean isInFipsMode;
    final JcaJceHelper helper;
    final X509TrustManager x509TrustManager;

    ImportX509TrustManager_5(boolean isInFipsMode, JcaJceHelper helper, X509TrustManager x509TrustManager) {
        this.isInFipsMode = isInFipsMode;
        this.helper = helper;
        this.x509TrustManager = x509TrustManager;
    }

    @Override
    public X509TrustManager unwrap() {
        return this.x509TrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.x509TrustManager.checkClientTrusted(ImportX509TrustManager_5.copyChain(chain), authType);
        this.checkAdditionalTrust(chain, authType, null, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.x509TrustManager.checkClientTrusted(ImportX509TrustManager_5.copyChain(chain), authType);
        this.checkAdditionalTrust(chain, authType, TransportData.from(socket), false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.x509TrustManager.checkClientTrusted(ImportX509TrustManager_5.copyChain(chain), authType);
        this.checkAdditionalTrust(chain, authType, TransportData.from(engine), false);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.x509TrustManager.checkServerTrusted(ImportX509TrustManager_5.copyChain(chain), authType);
        this.checkAdditionalTrust(chain, authType, null, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.x509TrustManager.checkServerTrusted(ImportX509TrustManager_5.copyChain(chain), authType);
        this.checkAdditionalTrust(chain, authType, TransportData.from(socket), true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.x509TrustManager.checkServerTrusted(ImportX509TrustManager_5.copyChain(chain), authType);
        this.checkAdditionalTrust(chain, authType, TransportData.from(engine), true);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.x509TrustManager.getAcceptedIssuers();
    }

    private void checkAdditionalTrust(X509Certificate[] chain, String authType, TransportData transportData, boolean checkServerTrusted) throws CertificateException {
        this.checkAlgorithmConstraints(chain, authType, transportData, checkServerTrusted);
        ProvX509TrustManager.checkExtendedTrust(chain, transportData, checkServerTrusted);
    }

    private void checkAlgorithmConstraints(X509Certificate[] chain, String authType, TransportData transportData, boolean checkServerTrusted) throws CertificateException {
        BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, false);
        Set<X509Certificate> trustedCerts = this.getTrustedCerts();
        KeyPurposeId ekuOID = ProvX509TrustManager.getRequiredExtendedKeyUsage(checkServerTrusted);
        int kuBit = ProvX509TrustManager.getRequiredKeyUsage(checkServerTrusted, authType);
        try {
            ProvAlgorithmChecker.checkChain(this.isInFipsMode, this.helper, algorithmConstraints, trustedCerts, chain, ekuOID, kuBit);
        }
        catch (GeneralSecurityException e) {
            throw new CertificateException("Certificates do not conform to algorithm constraints", e);
        }
    }

    private Set<X509Certificate> getTrustedCerts() {
        Object[] issuers = this.getAcceptedIssuers();
        if (TlsUtils.isNullOrEmpty(issuers)) {
            return Collections.emptySet();
        }
        HashSet<Object> trustedCerts = new HashSet<Object>();
        for (int i = 0; i < issuers.length; ++i) {
            Object issuer = issuers[i];
            if (null == issuer) continue;
            trustedCerts.add(issuer);
        }
        return Collections.unmodifiableSet(trustedCerts);
    }

    private static X509Certificate[] checkChain(X509Certificate[] chain) {
        if (TlsUtils.isNullOrEmpty(chain)) {
            throw new IllegalArgumentException("'chain' must be a chain of at least one certificate");
        }
        return chain;
    }

    private static X509Certificate[] copyChain(X509Certificate[] chain) {
        return (X509Certificate[])ImportX509TrustManager_5.checkChain(chain).clone();
    }
}

