/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSocketDirect;
import org.bouncycastle.jsse.provider.ProvSSLSocketDirect_9;
import org.bouncycastle.jsse.provider.ProvSSLSocketWrap;
import org.bouncycastle.jsse.provider.ProvSSLSocketWrap_9;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.SSLSessionUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLSocketUtil {
    private static AtomicInteger threadNumber = new AtomicInteger();

    SSLSocketUtil() {
    }

    static ProvSSLSocketDirect create(ContextData contextData, boolean bl, boolean bl2, ProvSSLParameters provSSLParameters) {
        return new ProvSSLSocketDirect_9(contextData, bl, bl2, provSSLParameters);
    }

    static ProvSSLSocketDirect create(ContextData contextData) {
        return new ProvSSLSocketDirect_9(contextData);
    }

    static ProvSSLSocketDirect create(ContextData contextData, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return new ProvSSLSocketDirect_9(contextData, inetAddress, n, inetAddress2, n2);
    }

    static ProvSSLSocketDirect create(ContextData contextData, InetAddress inetAddress, int n) throws IOException {
        return new ProvSSLSocketDirect_9(contextData, inetAddress, n);
    }

    static ProvSSLSocketDirect create(ContextData contextData, String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return new ProvSSLSocketDirect_9(contextData, string, n, inetAddress, n2);
    }

    static ProvSSLSocketDirect create(ContextData contextData, String string, int n) throws IOException, UnknownHostException {
        return new ProvSSLSocketDirect_9(contextData, string, n);
    }

    static ProvSSLSocketWrap create(ContextData contextData, Socket socket, InputStream inputStream, boolean bl) throws IOException {
        return new ProvSSLSocketWrap_9(contextData, socket, inputStream, bl);
    }

    static ProvSSLSocketWrap create(ContextData contextData, Socket socket, String string, int n, boolean bl) throws IOException {
        return new ProvSSLSocketWrap_9(contextData, socket, string, n, bl);
    }

    static void handshakeCompleted(Runnable runnable) {
        String string = "BCJSSE-HandshakeCompleted-" + Integer.toUnsignedString(threadNumber.getAndIncrement());
        new Thread(null, runnable, string, 0L, false).start();
    }

    static BCExtendedSSLSession importHandshakeSession(SSLSocket sSLSocket) {
        SSLSession sSLSession;
        if (sSLSocket instanceof BCSSLSocket) {
            return ((BCSSLSocket)((Object)sSLSocket)).getBCHandshakeSession();
        }
        if (null != sSLSocket && null != (sSLSession = sSLSocket.getHandshakeSession())) {
            return SSLSessionUtil.importSSLSession(sSLSession);
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLSocket sSLSocket) {
        if (sSLSocket instanceof BCSSLSocket) {
            return ((BCSSLSocket)((Object)sSLSocket)).getParameters();
        }
        if (null == sSLSocket) {
            return null;
        }
        SSLParameters sSLParameters = sSLSocket.getSSLParameters();
        if (null == sSLParameters) {
            throw new RuntimeException("SSLSocket.getSSLParameters returned null");
        }
        return SSLParametersUtil.importSSLParameters(sSLParameters);
    }
}

