/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.domaingroup;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.domaingroup.DomainGroupMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomainGroup
extends ServiceMBeanSupport
implements DomainGroupMBean {
    private static final long serialVersionUID = 3760843471744938808L;
    private static final Logger logger = Logger.getLogger(DomainGroup.class);
    private static final Pattern ipAddrPattern = Pattern.compile("^\\[(\\d+\\.\\d+\\.\\d+\\.\\d+)\\]$");
    private boolean includesLocalInterfaces;
    public String postmaster;
    private Set<String> domains = new TreeSet<String>(new CaseInsensitiveStringComparator());

    public DomainGroup(boolean includesLocalInterfaces) {
        this.includesLocalInterfaces = includesLocalInterfaces;
    }

    public DomainGroup() {
    }

    public void add(String domain) {
        String[] domainList = domain.trim().split(";");
        int i = 0;
        while (i < domainList.length) {
            this.domains.add(domainList[i]);
            ++i;
        }
    }

    public void remove(String domain) {
        String[] domainList = domain.trim().split(";");
        int i = 0;
        while (i < domainList.length) {
            this.domains.remove(domainList[i]);
            ++i;
        }
    }

    public String[] listDomains() {
        String[] retval = new String[this.domains.size()];
        retval = this.domains.toArray(retval);
        return retval;
    }

    public boolean isInGroup(String domain) {
        boolean isInGroup = this.domains.contains(domain);
        if (isInGroup) {
            return true;
        }
        if (this.includesLocalInterfaces) {
            this.includesLocalInterfaces = true;
            Matcher m = ipAddrPattern.matcher(domain);
            if (m.matches()) {
                try {
                    InetAddress addr = InetAddress.getByName(m.group(1));
                    return NetworkInterface.getByInetAddress(addr) != null;
                }
                catch (Exception e) {
                    logger.warn((Object)("problem processing address domain: " + domain), (Throwable)e);
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public boolean getIncludesLocalInterfaces() {
        return this.includesLocalInterfaces;
    }

    public String getPostmaster() {
        return this.postmaster;
    }

    public void setPostmaster(String postmaster) {
        this.postmaster = postmaster;
    }

    public void setDomains(Element element) {
        String attr = element.getAttribute("includes-local-interfaces");
        this.includesLocalInterfaces = attr.equals("true");
        NodeList list = element.getElementsByTagName("domain");
        this.domains.clear();
        int k = 0;
        while (k < list.getLength()) {
            Node n = list.item(k);
            this.add(DomainGroup.getNodeText(n).trim());
            ++k;
        }
    }

    private static String getNodeText(Node e) {
        StringBuffer buf = new StringBuffer();
        short type = e.getNodeType();
        if (type == 4 || type == 3) {
            buf.append(e.getNodeValue());
        } else if (type == 1) {
            NodeList list = e.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                buf.append(DomainGroup.getNodeText(child));
                ++i;
            }
        }
        return buf.toString();
    }

    public boolean isHostInGroup(String hostname) {
        hostname = hostname.trim().toLowerCase();
        boolean result = false;
        for (String domain : this.domains) {
            if (!hostname.endsWith(domain = domain.trim().toLowerCase())) continue;
            result = true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checked host: " + hostname + " in domains: " + this.domains + " result: " + result));
        }
        return result;
    }

    public static class CaseInsensitiveStringComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            return a.toString().toLowerCase().compareTo(b.toString().toLowerCase());
        }

        public boolean equals(Object c) {
            return c instanceof CaseInsensitiveStringComparator;
        }
    }
}

