/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.fetchmail;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import org.buni.meldware.mail.MailListenerChain;
import org.buni.meldware.mail.fetchmail.PopperMBean;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.message.MailCreateListener;
import org.buni.meldware.mail.message.Message;
import org.buni.meldware.mail.smtp.SMTPConstants;
import org.buni.meldware.mail.smtp.SMTPProtocolInstance;
import org.buni.meldware.mail.smtp.SMTPProtocolMBean;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

public class Popper
extends ServiceMBeanSupport
implements PopperMBean,
ServiceMBean,
SMTPConstants {
    private static final Logger log = Logger.getLogger(Popper.class);
    private String popUser;
    private String pass;
    private String popHost;
    private int popPort;
    private String localUser;
    private boolean doDeleteAfterPop;
    private SMTPProtocolMBean smtp;

    public void pop() {
        block13: {
            block14: {
                Properties p = new Properties();
                p.put("mail.host", this.popHost);
                p.put("mail.user", this.popUser);
                p.put("mail.store.protocol", "pop3");
                p.put("mail.pop3.host", this.popHost);
                Session ses = Session.getInstance((Properties)p);
                if (ses == null) break block14;
                Store store = null;
                try {
                    store = ses.getStore();
                    store.connect(this.popHost, this.popUser, this.pass);
                    Folder folder = store.getDefaultFolder();
                    folder = folder.getFolder("INBOX");
                    folder.open(2);
                    int count = folder.getMessageCount();
                    int nCount = folder.getNewMessageCount();
                    log.info((Object)("Found " + count + " messages (" + nCount + ") new ones"));
                    SMTPProtocolMBean spro = this.smtp;
                    SMTPProtocolInstance proto = spro.createInstance();
                    MailListenerChain chain = (MailListenerChain)proto.getProperty("ListenerChain");
                    int i = 0;
                    while (i < count) {
                        log.info((Object)("Trying to get message " + i));
                        javax.mail.Message msg = folder.getMessage(i + 1);
                        if (!this.doDeleteAfterPop && msg.isSet(Flags.Flag.SEEN)) {
                            log.info((Object)"  mail is old and DeleteAfterPop is false, so we don't fetch it");
                        } else {
                            log.info((Object)("Message " + i + " Subject: " + msg.getSubject()));
                            Enumeration hdrs = msg.getAllHeaders();
                            byte[] endinput = new byte[]{13, 10, 46, 13, 10};
                            InputStream inStream = new SequenceInputStream(msg.getInputStream(), new ByteArrayInputStream(endinput));
                            inStream = new BufferedInputStream(inStream);
                            if (inStream == null) {
                                log.warn((Object)"InputStream from Message is null");
                            }
                            Address[] from = msg.getFrom();
                            InternetAddress[] to = new InternetAddress[]{new InternetAddress()};
                            to[0].setAddress(this.localUser);
                            MailAddress mFrom = MailAddress.parseAddress((Address)from[0]);
                            MailAddress[] mTo = MailAddress.parseAddressArray((Address[])to);
                            HashMap<String, String> hdrMap = new HashMap<String, String>();
                            while (hdrs.hasMoreElements()) {
                                Header hdr = (Header)hdrs.nextElement();
                                hdrMap.put(hdr.getName(), hdr.getValue());
                            }
                            MailCreateListener mcl = proto.getMailCreateListener(mFrom, mTo, hdrMap);
                            MailBodyManager mgr = proto.getManager();
                            Mail mail = Mail.create((MailBodyManager)mgr, (InputStream)inStream, (MailCreateListener)mcl);
                            log.info((Object)"Mail created");
                            Mail mes = mail;
                            chain.processMail((Message)mes);
                            if (this.doDeleteAfterPop) {
                                log.debug((Object)"Marking this message to be deleted");
                                msg.setFlag(Flags.Flag.DELETED, true);
                            } else {
                                msg.setFlag(Flags.Flag.SEEN, true);
                            }
                            proto.resetState();
                        }
                        ++i;
                    }
                    if (this.doDeleteAfterPop) {
                        folder.close(true);
                    } else {
                        folder.close(false);
                    }
                    store.close();
                }
                catch (Exception e) {
                    log.error((Object)e);
                    e.printStackTrace();
                    if (store == null) break block13;
                    try {
                        store.close();
                        break block13;
                    }
                    catch (MessagingException messagingException) {}
                }
                break block13;
            }
            log.error((Object)"Can't obtain session");
        }
    }

    public String getPassword() {
        return this.pass;
    }

    public int getPopPort() {
        return this.popPort;
    }

    public String getServername() {
        return this.popHost;
    }

    public String getPopUser() {
        return this.popUser;
    }

    public void setPassword(String password) {
        this.pass = password;
    }

    public void setPopPort(int port) {
        this.popPort = port;
    }

    public void setServername(String name) {
        this.popHost = name;
    }

    public void setPopUser(String user) {
        this.popUser = user;
    }

    public String getLocalUser() {
        return this.localUser;
    }

    public void setLocalUser(String user) {
        this.localUser = user;
    }

    public boolean isDeleteAfterPop() {
        return this.doDeleteAfterPop;
    }

    public void setDeleteAfterPop(boolean doIt) {
        this.doDeleteAfterPop = doIt;
    }

    public void create() throws Exception {
        this.popPort = 110;
        this.doDeleteAfterPop = false;
    }

    public void setSMTPProtocol(SMTPProtocolMBean smtp) {
        this.smtp = smtp;
    }
}

