/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4;

import java.util.ArrayList;
import java.util.List;
import org.buni.meldware.mail.api.FolderBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BodyStructurePart {
    private String contentType;
    private String contentSubtype;
    private List<String> contentTypeParams;
    private String encoding;
    private String contentDisposition;
    private List<String> contentDispositionParams;
    private String bodySize;
    private String lineCount;

    public BodyStructurePart(FolderBody body) {
        if (body.getMimeheader() != null) {
            this.parseMimeHeader(body);
            this.bodySize = "" + body.getSize();
            this.lineCount = "" + (Math.round(body.getSize() / 80L) + 1);
            this.contentType = this.contentType != null ? this.contentType : "text";
            this.contentSubtype = this.contentType.equals("text") ? "plain" : this.contentSubtype;
            this.encoding = this.encoding == null ? "7bit" : this.encoding;
        } else {
            this.contentType = "text";
            this.contentSubtype = "plain";
            this.encoding = "7bit";
            this.bodySize = String.valueOf(body.getSize());
            this.lineCount = String.valueOf(Math.round(body.getSize() / 80L) + 1);
        }
    }

    private void parseMimeHeader(FolderBody body) {
        String mimeheaders = body.getMimeheader();
        String[] headerLines = mimeheaders.split("\\r\\n");
        int i = 0;
        while (i < headerLines.length) {
            String[] headerpieces = headerLines[i].split(":");
            String headerstart = headerpieces[0];
            if (headerstart.equals("Content-Type")) {
                if (headerLines.length > i + 1 && headerLines[i + 1].indexOf(58) < 0) {
                    this.parseContentType(headerLines[i], headerLines[i + 1]);
                    ++i;
                } else {
                    this.parseContentType(headerLines[i], null);
                }
            } else if (headerstart.equals("Content-Disposition")) {
                if (headerLines.length > i + 1 && headerLines[i + 1].indexOf(58) < 0) {
                    this.parseContentDisposition(headerLines[i], headerLines[i + 1]);
                    ++i;
                } else {
                    this.parseContentDisposition(headerLines[i], null);
                }
            } else if (headerstart.equals("Content-Transfer-Encoding")) {
                this.parseContentTransferEncoding(headerLines[i]);
            }
            ++i;
        }
    }

    private void parseContentTransferEncoding(String encoding) {
        this.encoding = encoding.split(":")[1].trim();
    }

    private void parseContentDisposition(String contentDispositionLine, String contentDispositionParam) {
        if (contentDispositionParam != null) {
            if (!contentDispositionLine.trim().endsWith(";")) {
                contentDispositionLine = String.valueOf(contentDispositionLine) + "; ";
            }
            contentDispositionLine = String.valueOf(contentDispositionLine) + contentDispositionParam.trim();
        }
        contentDispositionLine = contentDispositionLine.split(":")[1];
        String[] pieces = contentDispositionLine.split(";");
        this.contentDispositionParams = new ArrayList<String>(pieces.length - 1);
        int i = 1;
        while (i < pieces.length) {
            this.contentDispositionParams.add(pieces[i].trim());
            ++i;
        }
    }

    private void parseContentType(String contentTypeLine, String contentTypeParam) {
        if (contentTypeParam != null) {
            if (!contentTypeLine.trim().endsWith(";")) {
                contentTypeLine = String.valueOf(contentTypeLine) + "; ";
            }
            contentTypeLine = String.valueOf(contentTypeLine) + contentTypeParam.trim();
        }
        contentTypeLine = contentTypeLine.split(":")[1];
        String[] pieces = contentTypeLine.split(";");
        this.contentTypeParams = new ArrayList<String>(pieces.length - 1);
        this.contentType = pieces[0];
        if (this.contentType.indexOf(47) > -1) {
            String[] ctp = this.contentType.split("/");
            this.contentType = ctp[0];
            this.contentSubtype = ctp[1];
        }
        int i = 1;
        while (i < pieces.length) {
            this.contentTypeParams.add(pieces[i].trim());
            ++i;
        }
    }

    public String getBodySize() {
        return this.bodySize;
    }

    public void setBodySize(String bodySize) {
        this.bodySize = bodySize;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public List<String> getContentDispositionParams() {
        return this.contentDispositionParams;
    }

    public void setContentDispositionParams(List<String> contentDispositionParams) {
        this.contentDispositionParams = contentDispositionParams;
    }

    public String getContentSubtype() {
        return this.contentSubtype;
    }

    public void setContentSubtype(String contentSubtype) {
        this.contentSubtype = contentSubtype;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public List<String> getContentTypeParams() {
        return this.contentTypeParams;
    }

    public void setContentTypeParams(List<String> contentTypeParams) {
        this.contentTypeParams = contentTypeParams;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(String lineCount) {
        this.lineCount = lineCount;
    }
}

