/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import java.util.List;
import org.buni.meldware.mail.api.Folder;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;

public class ExpungeCommand
extends AbstractImapCommand {
    public ExpungeCommand() {
        super("EXPUNGE");
    }

    public boolean isValidForState() {
        return this.getProtocolInstance().getState() == 2;
    }

    public IMAP4Response execute() {
        IMAP4Response res = this.constructResponse();
        IMAP4ProtocolInstance pi = this.getProtocolInstance();
        if (!pi.isFolderReadOnly()) {
            Folder f = pi.getFolderProxy();
            List ids = f.expunge(true);
            for (Integer i : ids) {
                this.untaggedResponse(i + " EXPUNGE");
            }
            this.taggedSimpleSuccess();
        } else {
            this.taggedFailure("EXPUNGE failure: can't expunge: this folder is opened Read-Only.");
        }
        return res;
    }
}

