/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands.fetch;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.mail.StreamWriteException;
import org.buni.meldware.mail.api.FolderBody;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.imap4.BodyStructure;
import org.buni.meldware.mail.imap4.IMAP4OutputStream;
import org.buni.meldware.mail.imap4.commands.fetch.FetchPart;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.message.MailAddressFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePropertyPart
extends FetchPart {
    private static final String TEXT_BODY = "(\"TEXT\" \"PLAIN\" (\"CHARSET\" \"US-ASCII\") NIL NIL \"7BIT\" ";
    private static final String BODY_STR_HEADER = "(BODYSTRUCTURE ";
    private static final String R_PARN = ")";
    private static final Log log = Log.getLog(MessagePropertyPart.class);
    List supportedParts = Arrays.asList("BODYSTRUCTURE", "ENVELOPE", "FLAGS", "INTERNALDATE", "UID");
    private String name;

    public boolean canHandle(Object req) {
        return this.supportedParts.contains(req);
    }

    public MessagePropertyPart(String name) {
        this.name = name;
    }

    @Override
    public void fetch(FolderMessage msg, IMAP4OutputStream out) {
        try {
            out.write(this.name);
            out.write(" ");
            if ("BODYSTRUCTURE".equals(this.name)) {
                this.fetchBodyStructure(msg, out);
            } else if ("ENVELOPE".equals(this.name)) {
                this.fetchEnvelope(msg, out);
            } else if ("FLAGS".equals(this.name)) {
                this.fetchFlags(msg, out);
            } else if ("INTERNALDATE".equals(this.name)) {
                this.fetchInternaldate(msg, out);
            } else if ("UID".equals(this.name)) {
                this.fetchUID(msg, out);
            } else {
                out.write("UNKNOWN");
            }
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    private void fetchEnvelope(FolderMessage msg, IMAP4OutputStream out) {
        String date = msg.getHeader("Date");
        String subject = msg.getHeader("Subject");
        String fromLine = msg.getHeader("From");
        List from = MailAddressFactory.parseAddressList((CharSequence)fromLine);
        String senderLine = msg.getHeader("Sender");
        List sender = senderLine != null ? MailAddressFactory.parseAddressList((CharSequence)senderLine) : from;
        String replyToLine = msg.getHeader("Reply-To");
        List replyTo = replyToLine != null ? MailAddressFactory.parseAddressList((CharSequence)replyToLine) : from;
        String ccLine = msg.getHeader("Cc");
        List cc = MailAddressFactory.parseAddressList((CharSequence)ccLine);
        String bccLine = msg.getHeader("Cc");
        List bcc = MailAddressFactory.parseAddressList((CharSequence)bccLine);
        String inReplyTo = msg.getHeader("In-Reply-To");
        String messageId = msg.getHeader("Message-ID");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        this.appendString(sb, date);
        sb.append(" ");
        this.appendString(sb, subject);
        sb.append(" ");
        this.appendAddressList(sb, from);
        sb.append(" ");
        this.appendAddressList(sb, sender);
        sb.append(" ");
        this.appendAddressList(sb, replyTo);
        sb.append(" ");
        this.appendAddressList(sb, msg.getTo());
        sb.append(" ");
        this.appendAddressList(sb, cc);
        sb.append(" ");
        this.appendAddressList(sb, bcc);
        sb.append(" ");
        this.appendString(sb, inReplyTo);
        sb.append(" ");
        this.appendString(sb, messageId);
        sb.append(R_PARN);
        try {
            out.write(sb.toString());
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    private void appendString(StringBuilder sb, String val) {
        if (val != null) {
            sb.append("\"").append(val).append("\"");
        } else {
            sb.append("NIL");
        }
    }

    private void appendAddressList(StringBuilder sb, List<MailAddress> addresses) {
        if (addresses != null && addresses.size() != 0) {
            sb.append("(");
            for (MailAddress address : addresses) {
                sb.append(address.toIMAPString());
            }
            sb.append(R_PARN);
        } else {
            sb.append("NIL");
        }
    }

    void fetchBodyStructure(FolderMessage data, IMAP4OutputStream out) throws IOException {
        BodyStructure bs = new BodyStructure(data);
        out.write(bs.toString());
    }

    String textBodyStructure(FolderMessage data) {
        long size = ((FolderBody)data.getBody().get(0)).getSize();
        return TEXT_BODY + size + " " + Math.max(Math.round(size / 80L), 1) + R_PARN;
    }

    void fetchSize(FolderMessage message, IMAP4OutputStream out) {
        try {
            out.write(String.valueOf(message.getSize()));
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    void fetchUID(FolderMessage msg, IMAP4OutputStream out) {
        try {
            out.write(String.valueOf(msg.getUid()));
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    void fetchFlags(FolderMessage msg, IMAP4OutputStream out) {
        try {
            out.write("(");
            out.write(msg.getFlagString());
            out.write(R_PARN);
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    void fetchInternaldate(FolderMessage msg, IMAP4OutputStream out) {
        String thedate = msg.getHeader("Date");
        thedate = thedate == null ? "" : thedate;
        try {
            out.write("\"");
            out.write(thedate);
            out.write("\"");
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

