/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3;

import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.Request;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3Request;

public class MutablePOP3Request
implements POP3Request,
Request {
    private POP3ProtocolInstance protocol;
    private List<Object> arguments;
    private InputStream stream;
    private String strCommand;
    private Socket socket;

    public MutablePOP3Request(POP3ProtocolInstance instance, InputStream stream) {
        this.stream = stream;
        this.protocol = instance;
        this.arguments = new ArrayList<Object>(2);
    }

    public void setCommand(String strCommand) {
        this.strCommand = strCommand;
    }

    public String getCommand() {
        return this.strCommand;
    }

    public void addArgument(Object argument) {
        this.arguments.add(argument);
    }

    public Iterator arguments() {
        return this.arguments.iterator();
    }

    public String[] getArguments() {
        int count = 0;
        if (this.arguments != null) {
            count = this.arguments.size();
        }
        String[] argumentsArray = new String[count];
        if (count > 0) {
            this.arguments.toArray(argumentsArray);
        }
        return argumentsArray;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String getRemoteAddr() {
        return String.valueOf(this.socket.getInetAddress().getHostName()) + " (" + this.socket.getInetAddress().getHostAddress() + ")";
    }

    public InputStream getInputStream() {
        return this.stream;
    }
}

