/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp;

import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.Request;
import org.buni.meldware.mail.smtp.SMTPProtocolInstance;
import org.buni.meldware.mail.smtp.SMTPRequest;

public class MutableSMTPRequest
implements Request,
SMTPRequest {
    private SMTPProtocolInstance protocol;
    private List arguments;
    private InputStream stream;
    private String strCommand;
    private Socket socket;

    public MutableSMTPRequest(SMTPProtocolInstance instance, InputStream stream) {
        this.stream = stream;
        this.protocol = instance;
        this.arguments = new ArrayList(2);
    }

    public void setCommand(String strCommand) {
        this.strCommand = strCommand;
    }

    public String getCommand() {
        return this.strCommand;
    }

    public void addArgument(Object argument) {
        if (argument != null) {
            this.arguments.add(argument);
        }
    }

    public void addArgument(String argument) {
        if (argument != null) {
            this.arguments.add(argument.replaceAll("[\\r\\n\\t]", "").trim());
        }
    }

    public Iterator arguments() {
        return this.arguments.iterator();
    }

    public String[] getArguments() {
        int count = 0;
        if (this.arguments != null) {
            count = this.arguments.size();
        }
        String[] argumentsArray = new String[count];
        if (count > 0) {
            this.arguments.toArray(argumentsArray);
        }
        return argumentsArray;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String getRemoteAddr() {
        return String.valueOf(this.socket.getInetAddress().getHostName()) + " (" + this.socket.getInetAddress().getHostAddress() + ")";
    }

    public InputStream getInputStream() {
        return this.stream;
    }
}

