/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.smtp.SMTPConstants;
import org.buni.meldware.mail.smtp.SMTPRequest;
import org.buni.meldware.mail.smtp.SMTPResponse;
import org.buni.meldware.mail.smtp.handlers.SMTPHandler;
import org.jboss.logging.Logger;

public class CmdMAIL
implements SMTPHandler,
SMTPConstants {
    private static final Logger jblog = Logger.getLogger(CmdMAIL.class);
    public static final String COMMAND = "MAIL";

    public SMTPResponse handleRequest(OutputStream out, SMTPRequest request, Protocol protocol) throws IOException {
        jblog.debug((Object)"MAIL command handler called");
        SMTPResponse response = new SMTPResponse(request, out, protocol);
        PrintWriter writer = response.getWriter();
        String arg = this.getArgline(request.arguments());
        String sender = null;
        if (jblog.isDebugEnabled()) {
            jblog.debug((Object)("arg = " + arg));
        }
        if (arg != null && arg.indexOf(":") > 0) {
            jblog.debug((Object)"arg wasn't null");
            int colonIndex = arg.indexOf(":");
            jblog.debug((Object)("colonIndex=" + colonIndex));
            sender = arg.substring(colonIndex + 1);
            jblog.debug((Object)("sender=" + sender));
            arg = arg.substring(0, colonIndex);
            jblog.debug((Object)("arg=" + arg));
        }
        if (sender != null && arg != null && jblog.isDebugEnabled()) {
            jblog.debug((Object)("Sender= " + sender.trim() + " **arg = " + arg.trim()));
        }
        if (protocol.getState("SENDER") != null) {
            writer.println("503 Sender already specified");
        } else if (arg == null || !arg.toUpperCase(Locale.US).equals("FROM") || sender == null) {
            writer.println("501 Usage: MAIL FROM:<sender>");
        } else {
            int lastChar = (sender = sender.trim()).indexOf(62, sender.indexOf(60));
            if (lastChar > 0 && sender.length() > lastChar + 2 && sender.charAt(lastChar + 1) == ' ') {
                String mailOptionString = sender.substring(lastChar + 2);
                sender = sender.substring(0, lastChar + 1);
                this.parseMailOptions(mailOptionString);
            }
        }
        if (sender == null) {
            writer.println("501 Syntax error in MAIL command");
        } else if (!sender.startsWith("<") || !sender.endsWith(">")) {
            writer.println("501 Syntax error in MAIL command");
        } else {
            boolean isfrom = true;
            MailAddress address = MailAddress.parseSMTPStyle((String)sender, (boolean)isfrom);
            if (!address.isValid()) {
                writer.println("501 Syntax error in sender address");
            } else {
                protocol.setState("SENDER", (Object)address);
                writer.println("250 Sender " + sender + " OK");
            }
        }
        writer.flush();
        return response;
    }

    private boolean handleMailSize(String value, PrintWriter writer, Protocol protocol) {
        int size = 0;
        try {
            size = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            writer.println("501 Syntactically incorrect value for SIZE parameter");
            return false;
        }
        long maxMessageSize = (Long)protocol.getProperty("maxMessageSize");
        if (maxMessageSize > 0L && (long)size > maxMessageSize) {
            writer.println("552 Message size exceeds fixed maximum message size");
            return false;
        }
        protocol.setState(SMTPConstants.MSG_SIZE, (Object)new Integer(size));
        return true;
    }

    private Map parseMailOptions(String mailOptionString) {
        HashMap<String, String> options = new HashMap<String, String>();
        StringTokenizer optionTokenizer = new StringTokenizer(mailOptionString, " ");
        while (optionTokenizer.hasMoreElements()) {
            String mailOption = optionTokenizer.nextToken();
            int equalIndex = mailOption.indexOf(61);
            String mailOptionName = mailOption;
            String mailOptionValue = "";
            if (equalIndex > 0) {
                mailOptionName = mailOption.substring(0, equalIndex).toUpperCase(Locale.US);
                mailOptionValue = mailOption.substring(equalIndex + 1);
            }
            options.put(mailOptionName, mailOptionValue);
        }
        return options;
    }

    private String getArgline(Iterator iter) {
        String remote = null;
        if (iter.hasNext() && iter != null) {
            remote = (String)iter.next();
        }
        return remote;
    }
}

