/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.smtp.SMTPConstants;
import org.buni.meldware.mail.smtp.SMTPProtocolInstance;
import org.buni.meldware.mail.smtp.SMTPRequest;
import org.buni.meldware.mail.smtp.SMTPResponse;
import org.buni.meldware.mail.smtp.handlers.SMTPHandler;
import org.jboss.logging.Logger;

public class CmdRCPT
implements SMTPHandler,
SMTPConstants {
    private static final Logger jblog = Logger.getLogger(CmdRCPT.class);
    public static final String COMMAND = "RCPT";
    public static final String SENDER = "SENDER";
    public static final String MESG_SIZE = "MESG_SIZE";

    public SMTPResponse handleRequest(OutputStream out, SMTPRequest request, Protocol protocol) throws IOException {
        jblog.debug((Object)"RCPT command handler called");
        SMTPProtocolInstance smtpProtocol = (SMTPProtocolInstance)protocol;
        SMTPResponse response = new SMTPResponse(request, out, protocol);
        PrintWriter writer = response.getWriter();
        String[] arguments = this.parseArguments(this.getArgline(request.arguments()));
        String recipient = null;
        String argument = null;
        if (arguments.length > 0) {
            recipient = arguments[0];
        }
        if (arguments.length > 1) {
            argument = arguments[1];
        }
        if (protocol.getState(SENDER) == null) {
            writer.println("503 Need MAIL before RCPT");
        } else if (recipient == null || !argument.toUpperCase(Locale.US).equals("TO") || recipient.equals("")) {
            writer.println("501 Usage: RCPT TO:<recipient>");
        } else {
            ArrayList<MailAddress> rcpts = (ArrayList<MailAddress>)protocol.getState("RCPT_LIST");
            if (rcpts == null) {
                rcpts = new ArrayList<MailAddress>();
            }
            this.parseOptions(recipient);
            MailAddress rcpt = this.parseRecipient(recipient.trim());
            if (rcpt.isValid()) {
                if (smtpProtocol.handleAuth(rcpt, out, request, (SMTPProtocolInstance)protocol, response.getWriter())) {
                    if (this.handleRelay(smtpProtocol, rcpt)) {
                        rcpts.add(rcpt);
                        protocol.setState("RCPT_LIST", rcpts);
                        writer.println("250 Recipient " + recipient.trim() + " OK");
                    } else {
                        writer.println("553 Relaying disallowed");
                    }
                } else {
                    writer.println("550 Not Authorized");
                }
            } else {
                writer.println("501 Syntax error in recipient address");
            }
        }
        writer.flush();
        return response;
    }

    public boolean handleRelay(SMTPProtocolInstance protocol, MailAddress rcpt) {
        return protocol.isAuthenticated() || protocol.isMailAddressLocal(rcpt) || protocol.isRelayByDomainAllowed(rcpt);
    }

    private MailAddress parseRecipient(String recipient) {
        int lastChar = recipient.lastIndexOf(62);
        MailAddress retval = MailAddress.parseSMTPStyle((String)recipient.substring(0, lastChar + 1));
        return retval;
    }

    private Map parseOptions(String recipient) {
        HashMap<String, String> options = new HashMap<String, String>();
        int lastChar = recipient.lastIndexOf(62);
        if (lastChar > 0 && recipient.length() > lastChar + 2 && recipient.charAt(lastChar + 1) == ' ') {
            String rcptOptionString = recipient.substring(lastChar + 2);
            StringTokenizer optionTokenizer = new StringTokenizer(rcptOptionString, " ");
            while (optionTokenizer.hasMoreElements()) {
                String rcptOption = optionTokenizer.nextToken();
                int equalIndex = rcptOptionString.indexOf(61);
                String rcptOptionName = rcptOption;
                String rcptOptionValue = "";
                if (equalIndex > 0) {
                    rcptOptionName = rcptOption.substring(0, equalIndex).toUpperCase(Locale.US);
                    rcptOptionValue = rcptOption.substring(equalIndex + 1);
                }
                options.put(rcptOptionName, rcptOptionValue);
            }
        }
        return options;
    }

    private String[] parseArguments(String argline) {
        String[] args = new String[2];
        int colIndex = argline.indexOf(":");
        if (colIndex < 1) {
            return args;
        }
        args[0] = argline.substring(colIndex + 1);
        args[1] = argline.substring(0, colIndex);
        return args;
    }

    private String getArgline(Iterator iter) {
        String remote = null;
        if (iter.hasNext() && iter != null) {
            remote = (String)iter.next();
        }
        return remote;
    }
}

