/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp.sender;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.smtp.sender.MailAddressesByDomain;
import org.buni.meldware.mail.smtp.sender.SMTPResult;
import org.buni.meldware.mail.smtp.sender.SMTPResultImpl;
import org.buni.meldware.mail.smtp.sender.SMTPRoute;
import org.buni.meldware.mail.smtp.sender.SMTPSenderMBean;
import org.buni.meldware.mail.util.MMJMXUtil;
import org.columba.ristretto.log.RistrettoLogger;
import org.columba.ristretto.message.Address;
import org.columba.ristretto.parser.ParserException;
import org.columba.ristretto.smtp.SMTPException;
import org.columba.ristretto.smtp.SMTPProtocol;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

public class SMTPSender
extends ServiceMBeanSupport
implements SMTPSenderMBean {
    private static final long serialVersionUID = 3546639923579727921L;
    private Cache cache;
    private ExtendedResolver resolver;
    private boolean useCache;
    private boolean allRouted;
    private SMTPRoute soleRoute;
    Map<String, Resolver> resolvers = new HashMap<String, Resolver>();
    Map<ObjectName, SMTPRoute> routes = new HashMap<ObjectName, SMTPRoute>();
    Map<String, ObjectName> domainRoutes = new HashMap<String, ObjectName>();
    private boolean allowAddressLookups;
    private MailBodyManager mgr;

    protected void startService() throws Exception {
        this.cache = new Cache();
        if (this.resolvers.values().size() > 0) {
            Resolver[] r = this.resolvers.values().toArray(new Resolver[this.resolvers.values().size()]);
            this.resolver = new ExtendedResolver(r);
        } else {
            this.resolver = new ExtendedResolver();
        }
    }

    public void addDNSServer(String dns) throws UnknownHostException {
        SimpleResolver sr = new SimpleResolver(dns);
        if (this.resolver == null) {
            this.resolver = new ExtendedResolver();
        }
        this.resolver.addResolver((Resolver)sr);
        this.resolvers.put(dns, (Resolver)sr);
    }

    public void addDNSRoute(String nm) {
        try {
            if (this.allRouted) {
                throw new RuntimeException("you cannot add multiple routes when one is set to route all mail");
            }
            ObjectName name = new ObjectName(nm);
            SMTPRoute route = MMJMXUtil.getMBean(name, SMTPRoute.class);
            this.routes.put(name, route);
            if (!route.getRouteAll()) {
                String[] domains = route.getDomainGroup().listDomains();
                int i = 0;
                while (i < domains.length) {
                    this.domainRoutes.put(domains[i], name);
                    ++i;
                }
            } else {
                this.allRouted = true;
                this.soleRoute = route;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clearDNSCache() {
        this.cache = new Cache();
    }

    public boolean getCacheEnabled() {
        return this.useCache;
    }

    public Element getDNSServers() {
        return null;
    }

    public Element getDNSRoutes() {
        return null;
    }

    public String[] mxLookup(String address) {
        Record[] records = this.performMXLookup(address);
        String[] results = new String[records.length];
        int i = 0;
        while (i < records.length) {
            if (records[i] instanceof MXRecord) {
                results[i] = ((MXRecord)records[i]).getTarget().toString();
            } else if (records[i] instanceof ARecord) {
                results[i] = ((ARecord)records[i]).getAddress().getHostAddress();
            }
            ++i;
        }
        return results;
    }

    public String listDNSRoutes() {
        Iterator<ObjectName> it = this.routes.keySet().iterator();
        StringBuffer res = new StringBuffer();
        while (it.hasNext()) {
            res.append((String)((Object)it.next()));
            if (!it.hasNext()) continue;
            res.append(", ");
        }
        return res.toString();
    }

    public String listDNSServers() {
        Iterator<String> it = this.resolvers.keySet().iterator();
        StringBuffer res = new StringBuffer();
        while (it.hasNext()) {
            res.append(it.next());
            if (!it.hasNext()) continue;
            res.append(", ");
        }
        return res.toString();
    }

    private Record[] performMXLookup(String address) {
        ArrayList<Record> aRecords;
        block11: {
            SetResponse mxCached;
            Cache cache;
            block10: {
                Name name;
                cache = null;
                cache = this.useCache ? this.cache : new Cache();
                if (this.resolver == null) {
                    throw new RuntimeException("No name servers are mounted!  Mount one will you?");
                }
                try {
                    name = new Name(String.valueOf(address) + ".");
                }
                catch (TextParseException e) {
                    throw new RuntimeException("Invalid lookup ", e);
                }
                mxCached = this.queryDNS(cache, (Resolver)this.resolver, name, 15);
                aRecords = new ArrayList<Record>();
                if (mxCached.isSuccessful()) break block10;
                SetResponse aCached = this.queryDNS(cache, (Resolver)this.resolver, name, 1);
                if (!aCached.isSuccessful()) break block11;
                RRset[] rRsetArray = aCached.answers();
                int n = 0;
                int n2 = rRsetArray.length;
                while (n < n2) {
                    RRset rrset = rRsetArray[n];
                    Iterator i = rrset.rrs();
                    while (i.hasNext()) {
                        Record r = (Record)i.next();
                        aRecords.add(r);
                    }
                    ++n;
                }
                break block11;
            }
            ArrayList<Record> mxRecords = new ArrayList<Record>();
            RRset[] rRsetArray = mxCached.answers();
            int n = 0;
            int n3 = rRsetArray.length;
            while (n < n3) {
                RRset rrset = rRsetArray[n];
                Iterator i = rrset.rrs();
                while (i.hasNext()) {
                    Record r = (Record)i.next();
                    mxRecords.add(r);
                }
                ++n;
            }
            for (Record record : mxRecords) {
                MXRecord mxRecord;
                Name mxHost;
                SetResponse aCached;
                if (!(record instanceof MXRecord) || !(aCached = this.queryDNS(cache, (Resolver)this.resolver, mxHost = (mxRecord = (MXRecord)record).getTarget(), 1)).isSuccessful()) continue;
                RRset[] rRsetArray2 = aCached.answers();
                int n4 = 0;
                int n5 = rRsetArray2.length;
                while (n4 < n5) {
                    RRset rrset = rRsetArray2[n4];
                    Iterator i = rrset.rrs();
                    while (i.hasNext()) {
                        Record r = (Record)i.next();
                        aRecords.add(r);
                    }
                    ++n4;
                }
            }
        }
        return aRecords.toArray(new Record[aRecords.size()]);
    }

    private SetResponse queryDNS(Cache cache, Resolver resolver, Name name, int type) {
        try {
            Record r;
            Message q;
            Message response;
            short rcode;
            SetResponse aCached = cache.lookupRecords(name, type, (byte)3);
            if (!(aCached.isSuccessful() || (rcode = (response = resolver.send(q = Message.newQuery((Record)(r = Record.newRecord((Name)name, (int)type, (int)1))))).getHeader().getRcode()) != 0 && rcode != 3)) {
                cache.addMessage(response);
            }
            SetResponse cached = cache.lookupRecords(name, type, (byte)3);
            return cached;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not resolve DNS lookup", ioe);
        }
    }

    public void removeDNSServer(String dns) {
        Resolver r = this.resolvers.get(dns);
        this.resolver.deleteResolver(r);
        this.resolvers.remove(dns);
    }

    public void removeDNSRoute(String nm) {
        try {
            ObjectName name = new ObjectName(nm);
            SMTPRoute route = this.routes.remove(name);
            if (!route.getRouteAll()) {
                String[] domains = route.getDomainGroup().listDomains();
                int i = 0;
                while (i < domains.length) {
                    this.domainRoutes.remove(domains[i]);
                    ++i;
                }
            } else {
                this.allRouted = false;
                this.soleRoute = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SMTPResult[] send(Mail message, MailAddress[] exclude) {
        this.log.debug((Object)("sender - exclude:" + exclude));
        ArrayList results = new ArrayList(message.getTo().size());
        MailAddressesByDomain addrByDomain = new MailAddressesByDomain(message.getTo(), exclude);
        Iterator it = addrByDomain.getDomains();
        while (it.hasNext()) {
            String domain = (String)it.next();
            MailAddress[] addressesForDomain = addrByDomain.getAddresses(domain);
            ArrayList resultsForDomain = this.sendForDomain(addressesForDomain, message);
            results.addAll(resultsForDomain);
        }
        return results.toArray(new SMTPResult[results.size()]);
    }

    public SMTPResult send(MailAddress to, Mail mail) {
        return (SMTPResult)this.sendForDomain(new MailAddress[]{to}, mail).get(0);
    }

    public boolean isInvalidAddress(int code) {
        return code / 500 == 1;
    }

    public void addResults(Set addresses, int status, List results) {
        for (MailAddress ma : addresses) {
            SMTPResultImpl result = new SMTPResultImpl(ma, status);
            results.add(result);
        }
    }

    private ArrayList sendForDomain(MailAddress[] to, Mail mail) {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("before lookup domain = " + to[0].getDomain()));
            this.log.debug((Object)("resolve route yields = " + this.resolveRoute(to[0].getDomain())));
        }
        String[] hosts = this.mxLookup(this.resolveRoute(to[0].getDomain()));
        if (debug) {
            this.log.debug((Object)("hosts(length=" + hosts.length + ") = "));
            int k = 0;
            while (k < hosts.length) {
                this.log.debug((Object)("host[" + k + "] = " + hosts[k]));
                ++k;
            }
        }
        if (hosts.length < 1) {
            if (debug) {
                this.log.debug((Object)("Could not resolve MX lookup for " + to[0].getDomain() + ". Remote mail not sent"));
            }
            return SMTPResultImpl.getResolveDomainErrorForAll(to);
        }
        SMTPProtocol protocol = null;
        HashSet<MailAddress> invalid = new HashSet<MailAddress>();
        HashSet<MailAddress> retry = new HashSet<MailAddress>();
        HashSet<MailAddress> success = new HashSet<MailAddress>();
        RistrettoLogger.setLogStream((OutputStream)System.out);
        try {
            protocol = this.findHost(hosts);
            try {
                protocol.ehlo(InetAddress.getLocalHost());
            }
            catch (SMTPException sMTPException) {
                protocol.helo(InetAddress.getLocalHost());
            }
            protocol.mail(Address.parse((CharSequence)mail.getSender().toString()));
            this.log.info((Object)("Sending mail from: " + mail.getSender()));
            int i = 0;
            while (i < to.length) {
                try {
                    protocol.rcpt(Address.parse((CharSequence)to[i].toString()));
                    success.add(to[i]);
                    this.log.info((Object)("Delivering to: " + to[i]));
                }
                catch (ParserException parserException) {
                    invalid.add(to[i]);
                    this.log.error((Object)("Invalid Address: " + to[i]));
                }
                catch (SMTPException e) {
                    if (this.isInvalidAddress(e.getCode())) {
                        invalid.add(to[i]);
                        this.log.error((Object)("Invalid Address: " + to[i]));
                    }
                    retry.add(to[i]);
                    this.log.error((Object)("Delivery failed, will retry: " + to[i]));
                }
                ++i;
            }
            if (success.size() > 0) {
                protocol.data(mail.getRawStream(this.getMailBodyManager()));
                protocol.quit();
            } else {
                this.log.warn((Object)"Skipped data send, no valid addresses");
            }
            ArrayList results = new ArrayList();
            this.addResults(invalid, 4, results);
            this.addResults(retry, 3, results);
            this.addResults(success, 1, results);
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (IOException e) {
            this.log.error((Object)"Unble to send email.", (Throwable)e);
            ArrayList arrayList = SMTPResultImpl.getErrorForAll(to);
            return arrayList;
        }
        catch (SMTPException e) {
            this.log.error((Object)"Unble to send email.", (Throwable)e);
            ArrayList arrayList = SMTPResultImpl.getErrorForAll(to);
            return arrayList;
        }
        catch (ParserException e) {
            this.log.error((Object)"Unble to send email.", (Throwable)e);
            ArrayList arrayList = SMTPResultImpl.getErrorForAll(to);
            return arrayList;
        }
        finally {
            if (protocol != null) {
                try {
                    protocol.dropConnection();
                }
                catch (IOException e) {
                    this.log.warn((Object)"Error closing SMTP Connection: ", (Throwable)e);
                }
            }
        }
    }

    private SMTPProtocol findHost(String[] hosts) throws IOException {
        String[] stringArray = hosts;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            block6: {
                String host = stringArray[n];
                SMTPProtocol protocol = null;
                try {
                    this.log.info((Object)("Connecting to: " + host));
                    protocol = new SMTPProtocol(host);
                    protocol.openPort();
                    if (protocol.getState() == 1) {
                        return protocol;
                    }
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to connect to host, retrying next host; " + e.getMessage()));
                    if (protocol == null) break block6;
                    try {
                        protocol.dropConnection();
                    }
                    catch (IOException e1) {
                        this.log.warn((Object)"Error closing SMTP Connection: ", (Throwable)e1);
                    }
                }
            }
            ++n;
        }
        throw new IOException("Failed to connect to any SMTP Host: " + ArrayUtil.join((Object[])hosts, (String)","));
    }

    public void setCacheEnabled(boolean enabled) {
        this.useCache = enabled;
    }

    public void setDNSRoutes(Element servers) throws Exception {
        NodeList list = servers.getElementsByTagName("route");
        int k = 0;
        while (k < list.getLength()) {
            String route = SMTPSender.getNodeText(list.item(k)).trim();
            this.addDNSRoute(route);
            ++k;
        }
    }

    public void setDNSServers(Element servers) throws Exception {
        NodeList list = servers.getElementsByTagName("server");
        int k = 0;
        while (k < list.getLength()) {
            String server = SMTPSender.getNodeText(list.item(k)).trim();
            this.addDNSServer(server);
            ++k;
        }
    }

    private static String getNodeText(Node e) {
        StringBuffer buf = new StringBuffer();
        short type = e.getNodeType();
        if (type == 4 || type == 3) {
            buf.append(e.getNodeValue());
        } else if (type == 1) {
            NodeList list = e.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                buf.append(SMTPSender.getNodeText(child));
                ++i;
            }
        }
        return buf.toString();
    }

    private String[] resolveRoutes(String[] domains) {
        if (this.allRouted) {
            return new String[]{this.soleRoute.getHostname()};
        }
        String[] result = new String[domains.length];
        int i = 0;
        while (i < domains.length) {
            Object route = this.domainRoutes.get(domains[i]);
            route = route == null ? domains[i] : this.routes.get(route).getHostname();
            result[i] = (String)route;
            ++i;
        }
        return result;
    }

    private String resolveRoute(String domain) {
        return this.resolveRoutes(new String[]{domain})[0];
    }

    public boolean getAllowAddressLookups() {
        return this.allowAddressLookups;
    }

    public void setAllowAddressLookups(boolean allowAddressLookups) {
        this.allowAddressLookups = allowAddressLookups;
    }

    public MailBodyManager getMailBodyManager() {
        return this.mgr;
    }

    public void setMailBodyManager(MailBodyManager mgr) {
        this.mgr = mgr;
    }
}

