/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.buni.meldware.mail.store.AbstractStore;
import org.buni.meldware.mail.store.StoreException;
import org.buni.meldware.mail.store.StoreItemMetaData;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;

public class BlobInputStream
extends InputStream
implements Advised {
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    private ByteBuffer buffer = null;
    private int pageSize;
    private long position;
    private AbstractStore store;
    private StoreItemMetaData meta;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.store.BlobInputStream"));
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_read7185478378342678703;
    private static WeakReference aop$MethodInfo_read7587243480072713686;
    private static WeakReference aop$MethodInfo_doRead3031172050744626815;
    private static WeakReference aop$MethodInfo_loadBuffer_N_1335051867086815911;

    @Tx(value=TxType.REQUIRED)
    public BlobInputStream(AbstractStore store, StoreItemMetaData meta) throws StoreException {
        this.store = store;
        this.meta = meta;
        this.pageSize = meta.getPageSize();
        this.position = meta.getStartIndex();
    }

    @Tx(value=TxType.REQUIRED)
    public int org$buni$meldware$mail$store$BlobInputStream$read$aop() throws IOException {
        boolean isRead = false;
        if (this.buffer == null || !this.buffer.hasRemaining()) {
            int i = this.loadBuffer();
            boolean bl = isRead = i == 0;
        }
        if (isRead) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Tx(value=TxType.REQUIRED)
    public int org$buni$meldware$mail$store$BlobInputStream$read$aop(byte[] b, int off, int len) throws IOException {
        int fromBuffer = 0;
        int fromStore = 0;
        if (this.buffer == null || !this.buffer.hasRemaining()) {
            this.loadBuffer();
        }
        if (this.buffer.hasRemaining()) {
            fromBuffer = Math.min(this.buffer.remaining(), len);
            this.buffer.get(b, off, fromBuffer);
            if (fromBuffer < len) {
                fromStore = this.doRead(b, off + fromBuffer, len - fromBuffer);
            }
            return fromBuffer + fromStore;
        }
        return -1;
    }

    @Tx(value=TxType.REQUIRED)
    private int org$buni$meldware$mail$store$BlobInputStream$doRead$aop(byte[] b, int off, int len) throws IOException {
        try {
            int numBytes = this.store.read(this.meta.getPid(), this.position, b, off, len);
            if (numBytes > 0) {
                this.position += (long)numBytes;
            }
            return numBytes;
        }
        catch (StoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Tx(value=TxType.REQUIRED)
    private int org$buni$meldware$mail$store$BlobInputStream$loadBuffer$aop() throws IOException {
        try {
            this.buffer = this.store.getBuffer(this.meta.getPid(), this.position, this.pageSize);
            this.position += (long)this.buffer.limit();
            return this.buffer.limit();
        }
        catch (StoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        BlobInputStream blobInputStream = this;
        synchronized (blobInputStream) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        BlobInputStream blobInputStream = this;
        synchronized (blobInputStream) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    @Tx(value=TxType.REQUIRED)
    public int read() throws IOException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_read7185478378342678703.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            read_7185478378342678703 read_71854783783426787032 = new read_7185478378342678703(methodInfo, interceptorArray);
            read_71854783783426787032.setTargetObject(this);
            read_71854783783426787032.typedTargetObject = this;
            read_71854783783426787032.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)read_71854783783426787032.invokeNext();
        }
        return this.org$buni$meldware$mail$store$BlobInputStream$read$aop();
    }

    @Tx(value=TxType.REQUIRED)
    public int read(byte[] byArray, int n, int n2) throws IOException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_read7587243480072713686.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            read_7587243480072713686 read_75872434800727136862 = new read_7587243480072713686(methodInfo, interceptorArray);
            read_75872434800727136862.arg0 = byArray;
            read_75872434800727136862.arg1 = n;
            read_75872434800727136862.arg2 = n2;
            read_75872434800727136862.setTargetObject(this);
            read_75872434800727136862.typedTargetObject = this;
            read_75872434800727136862.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)read_75872434800727136862.invokeNext();
        }
        return this.org$buni$meldware$mail$store$BlobInputStream$read$aop(byArray, n, n2);
    }

    @Tx(value=TxType.REQUIRED)
    private int doRead(byte[] byArray, int n, int n2) throws IOException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_doRead3031172050744626815.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            doRead_3031172050744626815 doRead_30311720507446268152 = new doRead_3031172050744626815(methodInfo, interceptorArray);
            doRead_30311720507446268152.arg0 = byArray;
            doRead_30311720507446268152.arg1 = n;
            doRead_30311720507446268152.arg2 = n2;
            doRead_30311720507446268152.setTargetObject(this);
            doRead_30311720507446268152.typedTargetObject = this;
            doRead_30311720507446268152.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)doRead_30311720507446268152.invokeNext();
        }
        return this.org$buni$meldware$mail$store$BlobInputStream$doRead$aop(byArray, n, n2);
    }

    @Tx(value=TxType.REQUIRED)
    private int loadBuffer() throws IOException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_loadBuffer_N_1335051867086815911.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            loadBuffer_N1335051867086815911 loadBuffer_N13350518670868159112 = new loadBuffer_N1335051867086815911(methodInfo, interceptorArray);
            loadBuffer_N13350518670868159112.setTargetObject(this);
            loadBuffer_N13350518670868159112.typedTargetObject = this;
            loadBuffer_N13350518670868159112.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)loadBuffer_N13350518670868159112.invokeNext();
        }
        return this.org$buni$meldware$mail$store$BlobInputStream$loadBuffer$aop();
    }

    public static class read_7185478378342678703
    extends MethodInvocation
    implements Untransformable {
        public BlobInputStream typedTargetObject;

        public read_7185478378342678703(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public read_7185478378342678703(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public read_7185478378342678703(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public read_7185478378342678703() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$store$BlobInputStream$read$aop());
        }

        public Invocation copy() {
            read_7185478378342678703 read_71854783783426787032 = new read_7185478378342678703(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            read_71854783783426787032.arguments = this.arguments;
            ((InvocationBase)read_71854783783426787032).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)read_71854783783426787032).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)read_71854783783426787032).instanceResolver = ((InvocationBase)this).instanceResolver;
            read_71854783783426787032.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)read_71854783783426787032).targetObject = ((InvocationBase)this).targetObject;
            return read_71854783783426787032;
        }
    }

    public static class read_7587243480072713686
    extends MethodInvocation
    implements Untransformable {
        public byte[] arg0;
        public int arg1;
        public int arg2;
        public BlobInputStream typedTargetObject;

        public read_7587243480072713686(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public read_7587243480072713686(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public read_7587243480072713686(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public read_7587243480072713686() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$store$BlobInputStream$read$aop(this.arg0, this.arg1, this.arg2));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (byte[])object;
            this.arg1 = (Integer)objectArray[1];
            this.arg2 = (Integer)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            new Integer(this.arg1);
            new Integer(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            read_7587243480072713686 read_75872434800727136862 = new read_7587243480072713686(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            read_75872434800727136862.arguments = this.arguments;
            ((InvocationBase)read_75872434800727136862).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)read_75872434800727136862).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)read_75872434800727136862).instanceResolver = ((InvocationBase)this).instanceResolver;
            read_75872434800727136862.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)read_75872434800727136862).targetObject = ((InvocationBase)this).targetObject;
            read_75872434800727136862.arg0 = this.arg0;
            read_75872434800727136862.arg1 = this.arg1;
            read_75872434800727136862.arg2 = this.arg2;
            return read_75872434800727136862;
        }
    }

    public static class doRead_3031172050744626815
    extends MethodInvocation
    implements Untransformable {
        public byte[] arg0;
        public int arg1;
        public int arg2;
        public BlobInputStream typedTargetObject;

        public doRead_3031172050744626815(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public doRead_3031172050744626815(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public doRead_3031172050744626815(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public doRead_3031172050744626815() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$store$BlobInputStream$doRead$aop(this.arg0, this.arg1, this.arg2));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (byte[])object;
            this.arg1 = (Integer)objectArray[1];
            this.arg2 = (Integer)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            new Integer(this.arg1);
            new Integer(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            doRead_3031172050744626815 doRead_30311720507446268152 = new doRead_3031172050744626815(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            doRead_30311720507446268152.arguments = this.arguments;
            ((InvocationBase)doRead_30311720507446268152).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)doRead_30311720507446268152).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)doRead_30311720507446268152).instanceResolver = ((InvocationBase)this).instanceResolver;
            doRead_30311720507446268152.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)doRead_30311720507446268152).targetObject = ((InvocationBase)this).targetObject;
            doRead_30311720507446268152.arg0 = this.arg0;
            doRead_30311720507446268152.arg1 = this.arg1;
            doRead_30311720507446268152.arg2 = this.arg2;
            return doRead_30311720507446268152;
        }
    }

    public static class loadBuffer_N1335051867086815911
    extends MethodInvocation
    implements Untransformable {
        public BlobInputStream typedTargetObject;

        public loadBuffer_N1335051867086815911(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public loadBuffer_N1335051867086815911(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public loadBuffer_N1335051867086815911(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public loadBuffer_N1335051867086815911() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$store$BlobInputStream$loadBuffer$aop());
        }

        public Invocation copy() {
            loadBuffer_N1335051867086815911 loadBuffer_N13350518670868159112 = new loadBuffer_N1335051867086815911(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            loadBuffer_N13350518670868159112.arguments = this.arguments;
            ((InvocationBase)loadBuffer_N13350518670868159112).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)loadBuffer_N13350518670868159112).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)loadBuffer_N13350518670868159112).instanceResolver = ((InvocationBase)this).instanceResolver;
            loadBuffer_N13350518670868159112.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)loadBuffer_N13350518670868159112).targetObject = ((InvocationBase)this).targetObject;
            return loadBuffer_N13350518670868159112;
        }
    }
}

