/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.buni.meldware.mail.store.Store;
import org.buni.meldware.mail.store.StoreException;
import org.buni.meldware.mail.store.StoreItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryStore
implements Store {
    private volatile long seq = 1L;
    private Map<Long, ByteArrayOutputStream> data = new ConcurrentHashMap<Long, ByteArrayOutputStream>();

    protected synchronized Long doCreate() throws StoreException {
        Long l = new Long(this.seq);
        ++this.seq;
        this.data.put(l, new ByteArrayOutputStream());
        return l;
    }

    public void cleanUp(List<Long> bods) {
    }

    public void commit() {
    }

    public StoreItem createStoreItem() throws StoreException {
        return new MemoryStoreItem(this, this.doCreate());
    }

    public void delete(Long id) throws StoreException {
        this.data.remove(id);
    }

    public int getBufferSize() {
        return 8192;
    }

    public boolean getCompress() {
        return false;
    }

    public int getCompressBufferSize() {
        return 8192;
    }

    public boolean getHashed() {
        return false;
    }

    public int getPageSize() {
        return 8192;
    }

    public int getStartIndex() {
        return 0;
    }

    public StoreItem getStoreItem(Long id) throws StoreException {
        if (this.data.containsKey(id)) {
            return new MemoryStoreItem(this, id);
        }
        throw new StoreException("Item not found: " + id);
    }

    public String listMetaData() {
        return "";
    }

    public String toString(Long id) {
        return new String(this.data.get(id).toByteArray());
    }

    private static class MemoryStoreItem
    implements StoreItem {
        private Long id;
        private MemoryStore store;

        public MemoryStoreItem(MemoryStore store, Long id) {
            this.id = id;
            this.store = store;
        }

        public void delete() throws StoreException {
            this.store.delete(this.id);
        }

        public Long getId() {
            return this.id;
        }

        public InputStream getInputStream() throws StoreException {
            return new ByteArrayInputStream(((ByteArrayOutputStream)this.store.data.get(this.id)).toByteArray());
        }

        public OutputStream getOuputStream() throws StoreException {
            return (OutputStream)this.store.data.get(this.id);
        }

        public int getSize() throws StoreException {
            return ((ByteArrayOutputStream)this.store.data.get(this.id)).size();
        }

        public long getStartIndex() {
            return 0L;
        }
    }
}

