/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store.postgresql;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.store.BlobInputStream;
import org.buni.meldware.mail.store.BlobOutputStream;
import org.buni.meldware.mail.store.DBStore;
import org.buni.meldware.mail.store.StoreClerk;
import org.buni.meldware.mail.store.StoreException;
import org.buni.meldware.mail.store.StoreItemMetaData;
import org.buni.meldware.mail.store.postgresql.PGCloseListener;
import org.buni.meldware.mail.store.postgresql.PGUtil;
import org.buni.meldware.mail.store.postgresql.PostgreSQLStoreMBean;
import org.buni.meldware.mail.util.DbUtil;
import org.buni.meldware.mail.util.io.StreamCloseListener;
import org.buni.meldware.mail.util.io.WrappedInputStream;
import org.buni.meldware.mail.util.io.WrappedOutputStream;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;
import org.postgresql.PGConnection;
import org.postgresql.jdbc3.Jdbc3Connection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PostgreSQLStore
extends DBStore
implements PostgreSQLStoreMBean,
Advised {
    private static final String WRAPPED_CONNECTION_CLASS_NAME = "org.jboss.resource.adapter.jdbc.WrappedConnection";
    private static final String GET_PGCONNECTION_METHOD_NAME = "getUnderlyingConnection";
    private static Log log;
    private final Class wrappedConnectionClass;
    private final Method getPGConnectionMethod;
    private static ClassAdvisor aop$classAdvisor$aop;
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_getLargeObjectManager_N_1782288222771262018;
    private static WeakReference aop$MethodInfo_read_N_150580156191630418;
    private static WeakReference aop$MethodInfo_write_N_7611023959546435916;
    private static WeakReference aop$MethodInfo_getBuffer_N_8328802641894955898;
    private static WeakReference aop$MethodInfo_delete_N_169551518371285982;
    private static WeakReference aop$MethodInfo_doCreate3781003712992460599;
    private static WeakReference aop$MethodInfo_getBinaryStream_N_4675356532962834179;
    private static WeakReference aop$MethodInfo_setBinaryStream1553961704336164725;
    private static WeakReference aop$MethodInfo_getInputStream_N_2488121277901438923;
    private static WeakReference aop$MethodInfo_getOutputStream_N_3211327161428875046;

    static {
        aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.store.postgresql.PostgreSQLStore"));
        log = Log.getLog(PostgreSQLStore.class);
    }

    public PostgreSQLStore() {
        try {
            this.wrappedConnectionClass = Thread.currentThread().getContextClassLoader().loadClass(WRAPPED_CONNECTION_CLASS_NAME);
            this.getPGConnectionMethod = this.wrappedConnectionClass.getMethod(GET_PGCONNECTION_METHOD_NAME, new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to locate WrappedConnection methods", e);
        }
    }

    public String idToString(Object id) {
        return id.toString();
    }

    public Object stringToId(String s) {
        return new Integer(s);
    }

    @Override
    public void init() throws StoreException {
        log.info((Object)"Initalising PostgreSQL Store");
        super.init();
    }

    @Tx(value=TxType.REQUIRED)
    private LargeObjectManager org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getLargeObjectManager$aop(Connection cn) throws StoreException {
        LargeObjectManager mgr;
        if (cn instanceof PGConnection) {
            try {
                mgr = ((PGConnection)cn).getLargeObjectAPI();
            }
            catch (Exception e) {
                throw new StoreException("Unable to get reference to PGConnection", (Throwable)e);
            }
        }
        try {
            Object o = this.getPGConnectionMethod.invoke((Object)cn, new Object[0]);
            Jdbc3Connection jdbc3Cn = (Jdbc3Connection)o;
            mgr = jdbc3Cn.getLargeObjectAPI();
        }
        catch (Exception e) {
            log.error((Object)("Unable to get reference to PGConnection: " + e.getMessage()));
            throw new StoreException("Unable to get reference to PGConnection", (Throwable)e);
        }
        return mgr;
    }

    @Tx(value=TxType.REQUIRED)
    public int org$buni$meldware$mail$store$postgresql$PostgreSQLStore$read$aop(Long id, long position, byte[] b, int off, int len) throws StoreException {
        int numRead;
        Connection cn = null;
        LargeObject blob = null;
        int oid = id.intValue();
        log.debug((Object)("Read oid: " + id + ", position: " + position + ", length: " + len));
        try {
            try {
                cn = this.getConnection();
                LargeObjectManager mgr = this.getLargeObjectManager(cn);
                blob = mgr.open(oid);
                blob.seek(StoreClerk.longToInt(position));
                numRead = blob.read(b, off, len);
            }
            catch (SQLException e) {
                throw new StoreException("Read oid: " + id + ", position: " + position + ", length: " + len + " failed: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            PGUtil.closeQuietly(blob);
            DbUtil.closeQuietly((Log)log, (Connection)cn);
            throw throwable;
        }
        PGUtil.closeQuietly(blob);
        DbUtil.closeQuietly((Log)log, (Connection)cn);
        return numRead;
    }

    @Tx(value=TxType.REQUIRED)
    public int org$buni$meldware$mail$store$postgresql$PostgreSQLStore$write$aop(Long id, long position, byte[] b, int off, int len) throws StoreException {
        Connection cn = null;
        LargeObject blob = null;
        int oid = id.intValue();
        log.debug((Object)("Write oid: " + id + ", position: " + position + ", length: " + len));
        try {
            try {
                cn = this.getConnection();
                LargeObjectManager mgr = this.getLargeObjectManager(cn);
                blob = mgr.open(oid);
                blob.seek(StoreClerk.longToInt(position));
                blob.write(b, off, len);
            }
            catch (SQLException e) {
                throw new StoreException("Write oid: " + id + ", position: " + position + ", length: " + len, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            PGUtil.closeQuietly(blob);
            DbUtil.closeQuietly((Log)log, (Connection)cn);
            throw throwable;
        }
        PGUtil.closeQuietly(blob);
        DbUtil.closeQuietly((Log)log, (Connection)cn);
        return len;
    }

    @Tx(value=TxType.REQUIRED)
    public ByteBuffer org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getBuffer$aop(Long id, long position, int len) throws StoreException {
        ByteBuffer buffer;
        Connection cn = null;
        LargeObject blob = null;
        int oid = id.intValue();
        log.debug((Object)("Get Buffer oid: " + id + ", position: " + position + ", length: " + len));
        try {
            try {
                cn = this.getConnection();
                LargeObjectManager mgr = this.getLargeObjectManager(cn);
                blob = mgr.open(oid);
                blob.seek(StoreClerk.longToInt(position));
                byte[] b = new byte[len];
                int numRead = blob.read(b, 0, len);
                buffer = ByteBuffer.wrap(b, 0, numRead);
            }
            catch (SQLException e) {
                throw new StoreException("Get Buffer oid: " + id + ", position: " + position + ", length: " + len, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            PGUtil.closeQuietly(blob);
            DbUtil.closeQuietly((Log)log, (Connection)cn);
            throw throwable;
        }
        PGUtil.closeQuietly(blob);
        DbUtil.closeQuietly((Log)log, (Connection)cn);
        return buffer;
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$store$postgresql$PostgreSQLStore$delete$aop(Long id) throws StoreException {
        Connection cn = null;
        LargeObject blob = null;
        int oid = id.intValue();
        try {
            try {
                cn = this.getConnection();
                LargeObjectManager mgr = this.getLargeObjectManager(cn);
                mgr.unlink(oid);
            }
            catch (StoreException e) {
                throw e;
            }
            catch (SQLException e) {
                throw new StoreException((Throwable)e);
            }
        }
        finally {
            PGUtil.closeQuietly(blob);
            DbUtil.closeQuietly((Log)log, (Connection)cn);
        }
    }

    @Tx(value=TxType.REQUIRED)
    protected Long org$buni$meldware$mail$store$postgresql$PostgreSQLStore$doCreate$aop() throws StoreException {
        Long id;
        Connection cn = null;
        try {
            try {
                cn = this.getConnection();
                LargeObjectManager mgr = this.getLargeObjectManager(cn);
                id = new Long(mgr.create());
                log.debug((Object)("Created large object with id: " + id));
            }
            catch (SQLException e) {
                throw new StoreException("Create StoreItem", (Throwable)e);
            }
        }
        finally {
            DbUtil.closeQuietly((Log)log, (Connection)cn);
        }
        return id;
    }

    @Tx(value=TxType.REQUIRED)
    private InputStream org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getBinaryStream$aop(Long id) throws StoreException {
        WrappedInputStream in;
        Connection cn = null;
        int oid = id.intValue();
        try {
            cn = this.getConnection();
            LargeObjectManager mgr = this.getLargeObjectManager(cn);
            LargeObject blob = mgr.open(oid);
            in = new WrappedInputStream(blob.getInputStream());
            in.addListener((StreamCloseListener)new PGCloseListener(blob, cn));
        }
        catch (SQLException e) {
            throw new StoreException((Throwable)e);
        }
        return in;
    }

    @Tx(value=TxType.REQUIRED)
    private OutputStream org$buni$meldware$mail$store$postgresql$PostgreSQLStore$setBinaryStream$aop(Long id) throws StoreException {
        WrappedOutputStream out;
        Connection cn = null;
        int oid = id.intValue();
        try {
            cn = this.getConnection();
            LargeObjectManager mgr = this.getLargeObjectManager(cn);
            LargeObject blob = mgr.open(oid);
            out = new WrappedOutputStream(blob.getOutputStream());
            out.addListener((StreamCloseListener)new PGCloseListener(blob, cn));
        }
        catch (SQLException e) {
            throw new StoreException((Throwable)e);
        }
        return out;
    }

    @Tx(value=TxType.REQUIRED)
    public InputStream org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getInputStream$aop(Long id, StoreItemMetaData meta) throws StoreException {
        if (this.getDisconnected()) {
            return new BlobInputStream(this, meta);
        }
        return this.getBinaryStream(id);
    }

    @Tx(value=TxType.REQUIRED)
    public OutputStream org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getOutputStream$aop(Long id, StoreItemMetaData meta) throws StoreException {
        if (this.getDisconnected()) {
            return new BlobOutputStream(this, meta);
        }
        return this.setBinaryStream(id);
    }

    @Override
    public void validate() throws StoreException {
        super.validate();
    }

    public void cleanUp(List<Long> bods) {
        Connection cn = null;
        Statement stmt = null;
        try {
            try {
                cn = this.getConnection();
                stmt = cn.createStatement();
                String commaList = ArrayUtil.longListCommaDel(bods);
                stmt.execute("delete from pg_largeobject where loid in (" + commaList + ")");
                stmt.execute("delete from storeitemmetadata where pid in (" + commaList + ")");
            }
            catch (SQLException e) {
                throw new StoreException("expunging large objects failed: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DbUtil.closeQuietly((Log)log, stmt);
            DbUtil.closeQuietly((Log)log, (Connection)cn);
            throw throwable;
        }
        DbUtil.closeQuietly((Log)log, (Statement)stmt);
        DbUtil.closeQuietly((Log)log, (Connection)cn);
    }

    @Override
    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    @Override
    public InstanceAdvisor _getInstanceAdvisor() {
        PostgreSQLStore postgreSQLStore = this;
        synchronized (postgreSQLStore) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    @Override
    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        PostgreSQLStore postgreSQLStore = this;
        synchronized (postgreSQLStore) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    @Tx(value=TxType.REQUIRED)
    private LargeObjectManager getLargeObjectManager(Connection connection) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getLargeObjectManager_N_1782288222771262018.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getLargeObjectManager_N1782288222771262018 getLargeObjectManager_N17822882227712620182 = new getLargeObjectManager_N1782288222771262018(methodInfo, interceptorArray);
            getLargeObjectManager_N17822882227712620182.arg0 = connection;
            getLargeObjectManager_N17822882227712620182.setTargetObject(this);
            getLargeObjectManager_N17822882227712620182.typedTargetObject = this;
            getLargeObjectManager_N17822882227712620182.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (LargeObjectManager)getLargeObjectManager_N17822882227712620182.invokeNext();
        }
        return this.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getLargeObjectManager$aop(connection);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public int read(Long l, long l2, byte[] byArray, int n, int n2) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_read_N_150580156191630418.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            read_N150580156191630418 read_N1505801561916304182 = new read_N150580156191630418(methodInfo, interceptorArray);
            read_N1505801561916304182.arg0 = l;
            read_N1505801561916304182.arg1 = l2;
            read_N1505801561916304182.arg2 = byArray;
            read_N1505801561916304182.arg3 = n;
            read_N1505801561916304182.arg4 = n2;
            read_N1505801561916304182.setTargetObject(this);
            read_N1505801561916304182.typedTargetObject = this;
            read_N1505801561916304182.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)read_N1505801561916304182.invokeNext();
        }
        return this.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$read$aop(l, l2, byArray, n, n2);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public int write(Long l, long l2, byte[] byArray, int n, int n2) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_write_N_7611023959546435916.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            write_N7611023959546435916 write_N76110239595464359162 = new write_N7611023959546435916(methodInfo, interceptorArray);
            write_N76110239595464359162.arg0 = l;
            write_N76110239595464359162.arg1 = l2;
            write_N76110239595464359162.arg2 = byArray;
            write_N76110239595464359162.arg3 = n;
            write_N76110239595464359162.arg4 = n2;
            write_N76110239595464359162.setTargetObject(this);
            write_N76110239595464359162.typedTargetObject = this;
            write_N76110239595464359162.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)write_N76110239595464359162.invokeNext();
        }
        return this.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$write$aop(l, l2, byArray, n, n2);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public ByteBuffer getBuffer(Long l, long l2, int n) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getBuffer_N_8328802641894955898.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getBuffer_N8328802641894955898 getBuffer_N83288026418949558982 = new getBuffer_N8328802641894955898(methodInfo, interceptorArray);
            getBuffer_N83288026418949558982.arg0 = l;
            getBuffer_N83288026418949558982.arg1 = l2;
            getBuffer_N83288026418949558982.arg2 = n;
            getBuffer_N83288026418949558982.setTargetObject(this);
            getBuffer_N83288026418949558982.typedTargetObject = this;
            getBuffer_N83288026418949558982.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (ByteBuffer)getBuffer_N83288026418949558982.invokeNext();
        }
        return this.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getBuffer$aop(l, l2, n);
    }

    @Tx(value=TxType.REQUIRED)
    public void delete(Long l) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_delete_N_169551518371285982.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            delete_N169551518371285982 delete_N1695515183712859822 = new delete_N169551518371285982(methodInfo, interceptorArray);
            delete_N1695515183712859822.arg0 = l;
            delete_N1695515183712859822.setTargetObject(this);
            delete_N1695515183712859822.typedTargetObject = this;
            delete_N1695515183712859822.setAdvisor((Advisor)aop$classAdvisor$aop);
            delete_N1695515183712859822.invokeNext();
        } else {
            this.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$delete$aop(l);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    protected Long doCreate() throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_doCreate3781003712992460599.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            doCreate_3781003712992460599 doCreate_37810037129924605992 = new doCreate_3781003712992460599(methodInfo, interceptorArray);
            doCreate_37810037129924605992.setTargetObject(this);
            doCreate_37810037129924605992.typedTargetObject = this;
            doCreate_37810037129924605992.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Long)doCreate_37810037129924605992.invokeNext();
        }
        return this.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$doCreate$aop();
    }

    @Tx(value=TxType.REQUIRED)
    private InputStream getBinaryStream(Long l) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getBinaryStream_N_4675356532962834179.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getBinaryStream_N4675356532962834179 getBinaryStream_N46753565329628341792 = new getBinaryStream_N4675356532962834179(methodInfo, interceptorArray);
            getBinaryStream_N46753565329628341792.arg0 = l;
            getBinaryStream_N46753565329628341792.setTargetObject(this);
            getBinaryStream_N46753565329628341792.typedTargetObject = this;
            getBinaryStream_N46753565329628341792.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (InputStream)getBinaryStream_N46753565329628341792.invokeNext();
        }
        return this.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getBinaryStream$aop(l);
    }

    @Tx(value=TxType.REQUIRED)
    private OutputStream setBinaryStream(Long l) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_setBinaryStream1553961704336164725.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            setBinaryStream_1553961704336164725 setBinaryStream_15539617043361647252 = new setBinaryStream_1553961704336164725(methodInfo, interceptorArray);
            setBinaryStream_15539617043361647252.arg0 = l;
            setBinaryStream_15539617043361647252.setTargetObject(this);
            setBinaryStream_15539617043361647252.typedTargetObject = this;
            setBinaryStream_15539617043361647252.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (OutputStream)setBinaryStream_15539617043361647252.invokeNext();
        }
        return this.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$setBinaryStream$aop(l);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public InputStream getInputStream(Long l, StoreItemMetaData storeItemMetaData) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getInputStream_N_2488121277901438923.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getInputStream_N2488121277901438923 getInputStream_N24881212779014389232 = new getInputStream_N2488121277901438923(methodInfo, interceptorArray);
            getInputStream_N24881212779014389232.arg0 = l;
            getInputStream_N24881212779014389232.arg1 = storeItemMetaData;
            getInputStream_N24881212779014389232.setTargetObject(this);
            getInputStream_N24881212779014389232.typedTargetObject = this;
            getInputStream_N24881212779014389232.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (InputStream)getInputStream_N24881212779014389232.invokeNext();
        }
        return this.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getInputStream$aop(l, storeItemMetaData);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public OutputStream getOutputStream(Long l, StoreItemMetaData storeItemMetaData) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getOutputStream_N_3211327161428875046.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getOutputStream_N3211327161428875046 getOutputStream_N32113271614288750462 = new getOutputStream_N3211327161428875046(methodInfo, interceptorArray);
            getOutputStream_N32113271614288750462.arg0 = l;
            getOutputStream_N32113271614288750462.arg1 = storeItemMetaData;
            getOutputStream_N32113271614288750462.setTargetObject(this);
            getOutputStream_N32113271614288750462.typedTargetObject = this;
            getOutputStream_N32113271614288750462.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (OutputStream)getOutputStream_N32113271614288750462.invokeNext();
        }
        return this.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getOutputStream$aop(l, storeItemMetaData);
    }

    public static class getLargeObjectManager_N1782288222771262018
    extends MethodInvocation
    implements Untransformable {
        public Connection arg0;
        public PostgreSQLStore typedTargetObject;

        public getLargeObjectManager_N1782288222771262018(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getLargeObjectManager_N1782288222771262018(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getLargeObjectManager_N1782288222771262018(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getLargeObjectManager_N1782288222771262018() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getLargeObjectManager$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Connection)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getLargeObjectManager_N1782288222771262018 getLargeObjectManager_N17822882227712620182 = new getLargeObjectManager_N1782288222771262018(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getLargeObjectManager_N17822882227712620182.arguments = this.arguments;
            ((InvocationBase)getLargeObjectManager_N17822882227712620182).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getLargeObjectManager_N17822882227712620182).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getLargeObjectManager_N17822882227712620182).instanceResolver = ((InvocationBase)this).instanceResolver;
            getLargeObjectManager_N17822882227712620182.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getLargeObjectManager_N17822882227712620182).targetObject = ((InvocationBase)this).targetObject;
            getLargeObjectManager_N17822882227712620182.arg0 = this.arg0;
            return getLargeObjectManager_N17822882227712620182;
        }
    }

    public static class read_N150580156191630418
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public long arg1;
        public byte[] arg2;
        public int arg3;
        public int arg4;
        public PostgreSQLStore typedTargetObject;

        public read_N150580156191630418(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public read_N150580156191630418(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public read_N150580156191630418(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public read_N150580156191630418() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$read$aop(this.arg0, this.arg1, this.arg2, this.arg3, this.arg4));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            this.arg1 = (Long)objectArray[1];
            Object object2 = objectArray[2];
            this.arg2 = (byte[])object2;
            this.arg3 = (Integer)objectArray[3];
            this.arg4 = (Integer)objectArray[4];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[5];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            this.arguments[2] = this.arg2;
            new Integer(this.arg3);
            new Integer(this.arg4);
            return this.arguments;
        }

        public Invocation copy() {
            read_N150580156191630418 read_N1505801561916304182 = new read_N150580156191630418(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            read_N1505801561916304182.arguments = this.arguments;
            ((InvocationBase)read_N1505801561916304182).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)read_N1505801561916304182).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)read_N1505801561916304182).instanceResolver = ((InvocationBase)this).instanceResolver;
            read_N1505801561916304182.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)read_N1505801561916304182).targetObject = ((InvocationBase)this).targetObject;
            read_N1505801561916304182.arg0 = this.arg0;
            read_N1505801561916304182.arg1 = this.arg1;
            read_N1505801561916304182.arg2 = this.arg2;
            read_N1505801561916304182.arg3 = this.arg3;
            read_N1505801561916304182.arg4 = this.arg4;
            return read_N1505801561916304182;
        }
    }

    public static class write_N7611023959546435916
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public long arg1;
        public byte[] arg2;
        public int arg3;
        public int arg4;
        public PostgreSQLStore typedTargetObject;

        public write_N7611023959546435916(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public write_N7611023959546435916(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public write_N7611023959546435916(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public write_N7611023959546435916() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$write$aop(this.arg0, this.arg1, this.arg2, this.arg3, this.arg4));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            this.arg1 = (Long)objectArray[1];
            Object object2 = objectArray[2];
            this.arg2 = (byte[])object2;
            this.arg3 = (Integer)objectArray[3];
            this.arg4 = (Integer)objectArray[4];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[5];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            this.arguments[2] = this.arg2;
            new Integer(this.arg3);
            new Integer(this.arg4);
            return this.arguments;
        }

        public Invocation copy() {
            write_N7611023959546435916 write_N76110239595464359162 = new write_N7611023959546435916(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            write_N76110239595464359162.arguments = this.arguments;
            ((InvocationBase)write_N76110239595464359162).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)write_N76110239595464359162).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)write_N76110239595464359162).instanceResolver = ((InvocationBase)this).instanceResolver;
            write_N76110239595464359162.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)write_N76110239595464359162).targetObject = ((InvocationBase)this).targetObject;
            write_N76110239595464359162.arg0 = this.arg0;
            write_N76110239595464359162.arg1 = this.arg1;
            write_N76110239595464359162.arg2 = this.arg2;
            write_N76110239595464359162.arg3 = this.arg3;
            write_N76110239595464359162.arg4 = this.arg4;
            return write_N76110239595464359162;
        }
    }

    public static class getBuffer_N8328802641894955898
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public long arg1;
        public int arg2;
        public PostgreSQLStore typedTargetObject;

        public getBuffer_N8328802641894955898(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getBuffer_N8328802641894955898(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getBuffer_N8328802641894955898(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getBuffer_N8328802641894955898() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getBuffer$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            this.arg1 = (Long)objectArray[1];
            this.arg2 = (Integer)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            new Integer(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            getBuffer_N8328802641894955898 getBuffer_N83288026418949558982 = new getBuffer_N8328802641894955898(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getBuffer_N83288026418949558982.arguments = this.arguments;
            ((InvocationBase)getBuffer_N83288026418949558982).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getBuffer_N83288026418949558982).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getBuffer_N83288026418949558982).instanceResolver = ((InvocationBase)this).instanceResolver;
            getBuffer_N83288026418949558982.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getBuffer_N83288026418949558982).targetObject = ((InvocationBase)this).targetObject;
            getBuffer_N83288026418949558982.arg0 = this.arg0;
            getBuffer_N83288026418949558982.arg1 = this.arg1;
            getBuffer_N83288026418949558982.arg2 = this.arg2;
            return getBuffer_N83288026418949558982;
        }
    }

    public static class delete_N169551518371285982
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public PostgreSQLStore typedTargetObject;

        public delete_N169551518371285982(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public delete_N169551518371285982(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public delete_N169551518371285982(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public delete_N169551518371285982() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$delete$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            delete_N169551518371285982 delete_N1695515183712859822 = new delete_N169551518371285982(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            delete_N1695515183712859822.arguments = this.arguments;
            ((InvocationBase)delete_N1695515183712859822).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)delete_N1695515183712859822).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)delete_N1695515183712859822).instanceResolver = ((InvocationBase)this).instanceResolver;
            delete_N1695515183712859822.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)delete_N1695515183712859822).targetObject = ((InvocationBase)this).targetObject;
            delete_N1695515183712859822.arg0 = this.arg0;
            return delete_N1695515183712859822;
        }
    }

    public static class doCreate_3781003712992460599
    extends MethodInvocation
    implements Untransformable {
        public PostgreSQLStore typedTargetObject;

        public doCreate_3781003712992460599(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public doCreate_3781003712992460599(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public doCreate_3781003712992460599(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public doCreate_3781003712992460599() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$doCreate$aop();
        }

        public Invocation copy() {
            doCreate_3781003712992460599 doCreate_37810037129924605992 = new doCreate_3781003712992460599(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            doCreate_37810037129924605992.arguments = this.arguments;
            ((InvocationBase)doCreate_37810037129924605992).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)doCreate_37810037129924605992).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)doCreate_37810037129924605992).instanceResolver = ((InvocationBase)this).instanceResolver;
            doCreate_37810037129924605992.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)doCreate_37810037129924605992).targetObject = ((InvocationBase)this).targetObject;
            return doCreate_37810037129924605992;
        }
    }

    public static class getBinaryStream_N4675356532962834179
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public PostgreSQLStore typedTargetObject;

        public getBinaryStream_N4675356532962834179(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getBinaryStream_N4675356532962834179(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getBinaryStream_N4675356532962834179(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getBinaryStream_N4675356532962834179() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getBinaryStream$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getBinaryStream_N4675356532962834179 getBinaryStream_N46753565329628341792 = new getBinaryStream_N4675356532962834179(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getBinaryStream_N46753565329628341792.arguments = this.arguments;
            ((InvocationBase)getBinaryStream_N46753565329628341792).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getBinaryStream_N46753565329628341792).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getBinaryStream_N46753565329628341792).instanceResolver = ((InvocationBase)this).instanceResolver;
            getBinaryStream_N46753565329628341792.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getBinaryStream_N46753565329628341792).targetObject = ((InvocationBase)this).targetObject;
            getBinaryStream_N46753565329628341792.arg0 = this.arg0;
            return getBinaryStream_N46753565329628341792;
        }
    }

    public static class setBinaryStream_1553961704336164725
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public PostgreSQLStore typedTargetObject;

        public setBinaryStream_1553961704336164725(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public setBinaryStream_1553961704336164725(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public setBinaryStream_1553961704336164725(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public setBinaryStream_1553961704336164725() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$setBinaryStream$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            setBinaryStream_1553961704336164725 setBinaryStream_15539617043361647252 = new setBinaryStream_1553961704336164725(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            setBinaryStream_15539617043361647252.arguments = this.arguments;
            ((InvocationBase)setBinaryStream_15539617043361647252).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)setBinaryStream_15539617043361647252).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)setBinaryStream_15539617043361647252).instanceResolver = ((InvocationBase)this).instanceResolver;
            setBinaryStream_15539617043361647252.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)setBinaryStream_15539617043361647252).targetObject = ((InvocationBase)this).targetObject;
            setBinaryStream_15539617043361647252.arg0 = this.arg0;
            return setBinaryStream_15539617043361647252;
        }
    }

    public static class getInputStream_N2488121277901438923
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public StoreItemMetaData arg1;
        public PostgreSQLStore typedTargetObject;

        public getInputStream_N2488121277901438923(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getInputStream_N2488121277901438923(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getInputStream_N2488121277901438923(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getInputStream_N2488121277901438923() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getInputStream$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            Object object2 = objectArray[1];
            this.arg1 = (StoreItemMetaData)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            getInputStream_N2488121277901438923 getInputStream_N24881212779014389232 = new getInputStream_N2488121277901438923(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getInputStream_N24881212779014389232.arguments = this.arguments;
            ((InvocationBase)getInputStream_N24881212779014389232).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getInputStream_N24881212779014389232).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getInputStream_N24881212779014389232).instanceResolver = ((InvocationBase)this).instanceResolver;
            getInputStream_N24881212779014389232.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getInputStream_N24881212779014389232).targetObject = ((InvocationBase)this).targetObject;
            getInputStream_N24881212779014389232.arg0 = this.arg0;
            getInputStream_N24881212779014389232.arg1 = this.arg1;
            return getInputStream_N24881212779014389232;
        }
    }

    public static class getOutputStream_N3211327161428875046
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public StoreItemMetaData arg1;
        public PostgreSQLStore typedTargetObject;

        public getOutputStream_N3211327161428875046(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getOutputStream_N3211327161428875046(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getOutputStream_N3211327161428875046(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getOutputStream_N3211327161428875046() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$postgresql$PostgreSQLStore$getOutputStream$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            Object object2 = objectArray[1];
            this.arg1 = (StoreItemMetaData)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            getOutputStream_N3211327161428875046 getOutputStream_N32113271614288750462 = new getOutputStream_N3211327161428875046(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getOutputStream_N32113271614288750462.arguments = this.arguments;
            ((InvocationBase)getOutputStream_N32113271614288750462).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getOutputStream_N32113271614288750462).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getOutputStream_N32113271614288750462).instanceResolver = ((InvocationBase)this).instanceResolver;
            getOutputStream_N32113271614288750462.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getOutputStream_N32113271614288750462).targetObject = ((InvocationBase)this).targetObject;
            getOutputStream_N32113271614288750462.arg0 = this.arg0;
            getOutputStream_N32113271614288750462.arg1 = this.arg1;
            return getOutputStream_N32113271614288750462;
        }
    }
}

