/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store.s3;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.buni.meldware.mail.store.StoreException;
import org.buni.meldware.mail.store.StoreItemMetaData;
import org.buni.s3filestore.S3FileStore;
import org.buni.s3filestore.S3InputStream;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3FileStoreServiceUUIDImpl
implements Advised {
    S3FileStore s3FileStore;
    private String defaultS3Host = "s3.amazonws.com";
    private boolean useSSL = new Boolean(true);
    private String awsSystemAccessKey;
    private String awsSystemSecretAccessKey;
    private String defaultBucket = "";
    private String defaultPath = "meldware/messages";
    private int numRetries = 3;
    private int retrySleep = 2000;
    private long maxS3FileSize = 0x140000000L;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.store.s3.S3FileStoreServiceUUIDImpl"));
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_getBuffer_N_450063724849662748;

    public void init() {
        Properties props = new Properties();
        props.put("defaultS3Host", this.defaultS3Host);
        props.put("useSSL", (Object)this.useSSL);
        props.put("awsSystemAccessKey", this.awsSystemAccessKey);
        props.put("awsSystemSecretAccessKey", this.awsSystemSecretAccessKey);
        props.put("defaultBucket", this.defaultBucket);
        props.put("defaultPath", this.defaultPath);
        props.put("maxS3FileSize", (Object)this.maxS3FileSize);
        props.put("numRetries", (Object)this.numRetries);
        props.put("retrySleep", (Object)this.retrySleep);
        this.s3FileStore = new S3FileStore(props);
    }

    protected UUID doCreate() throws StoreException {
        try {
            return UUID.randomUUID();
        }
        catch (Exception e) {
            throw new StoreException((Throwable)e);
        }
    }

    public void cleanUp(List<UUID> bods) {
        int i = 0;
        while (i < bods.size()) {
            this.delete(bods.get(i));
            ++i;
        }
    }

    public void delete(UUID id) throws StoreException {
        this.s3FileStore.delete(id);
    }

    @Tx(value=TxType.REQUIRED)
    public ByteBuffer org$buni$meldware$mail$store$s3$S3FileStoreServiceUUIDImpl$getBuffer$aop(UUID id, long position, int len) throws StoreException {
        ByteBuffer buffer;
        try {
            S3InputStream iStream = this.s3FileStore.getInputStream(id, position, len);
            byte[] b = new byte[len];
            int numRead = iStream.read(b, 0, len);
            buffer = ByteBuffer.wrap(b, 0, numRead);
            iStream.close();
        }
        catch (Exception e) {
            throw new StoreException((Throwable)e);
        }
        return buffer;
    }

    public InputStream getInputStream(UUID id, StoreItemMetaData meta) throws StoreException {
        try {
            return this.s3FileStore.getInputStream(id, null);
        }
        catch (Exception e) {
            throw new StoreException((Throwable)e);
        }
    }

    public OutputStream getOutputStream(UUID id, StoreItemMetaData meta) throws StoreException {
        try {
            return this.s3FileStore.getOutputStream(id, null);
        }
        catch (Exception e) {
            throw new StoreException((Throwable)e);
        }
    }

    public String idToString(Object id) {
        return id.toString();
    }

    public int read(UUID id, long position, byte[] b, int off, int len) throws StoreException {
        int read = 0;
        try {
            S3InputStream iStream = this.s3FileStore.getInputStream(id, position, -1, null);
            read = iStream.read(b, off, len);
            iStream.close();
        }
        catch (Exception e) {
            throw new StoreException((Throwable)e);
        }
        return read;
    }

    public Object stringToUUID(String s) {
        return UUID.fromString(s);
    }

    public int write(UUID id, long position, byte[] b, int off, int len) throws StoreException {
        throw new StoreException("Amazon S3 does not allow partial writes.  Please use 'getOutputStream(..) instead to write an entire file.");
    }

    public String getAwsSystemAccessKey() {
        return this.awsSystemAccessKey;
    }

    public void setAwsSystemAccessKey(String awsSystemAccessKey) {
        this.awsSystemAccessKey = awsSystemAccessKey;
    }

    public String getAwsSystemSecretAccessKey() {
        return this.awsSystemSecretAccessKey;
    }

    public void setAwsSystemSecretAccessKey(String awsSystemSecretAccessKey) {
        this.awsSystemSecretAccessKey = awsSystemSecretAccessKey;
    }

    public String getDefaultBucket() {
        return this.defaultBucket;
    }

    public void setDefaultBucket(String defaultBucket) {
        this.defaultBucket = defaultBucket;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public void setDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
    }

    public String getDefaultS3Host() {
        return this.defaultS3Host;
    }

    public void setDefaultS3Host(String defaultS3Host) {
        this.defaultS3Host = defaultS3Host;
    }

    public long getMaxS3FileSize() {
        return this.maxS3FileSize;
    }

    public void setMaxS3FileSize(long maxS3FileSize) {
        this.maxS3FileSize = maxS3FileSize;
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public void setNumRetries(int numRetries) {
        this.numRetries = numRetries;
    }

    public int getRetrySleep() {
        return this.retrySleep;
    }

    public void setRetrySleep(int retrySleep) {
        this.retrySleep = retrySleep;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        S3FileStoreServiceUUIDImpl s3FileStoreServiceUUIDImpl = this;
        synchronized (s3FileStoreServiceUUIDImpl) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        S3FileStoreServiceUUIDImpl s3FileStoreServiceUUIDImpl = this;
        synchronized (s3FileStoreServiceUUIDImpl) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    @Tx(value=TxType.REQUIRED)
    public ByteBuffer getBuffer(UUID uUID, long l, int n) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getBuffer_N_450063724849662748.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getBuffer_N450063724849662748 getBuffer_N4500637248496627482 = new getBuffer_N450063724849662748(methodInfo, interceptorArray);
            getBuffer_N4500637248496627482.arg0 = uUID;
            getBuffer_N4500637248496627482.arg1 = l;
            getBuffer_N4500637248496627482.arg2 = n;
            getBuffer_N4500637248496627482.setTargetObject(this);
            getBuffer_N4500637248496627482.typedTargetObject = this;
            getBuffer_N4500637248496627482.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (ByteBuffer)getBuffer_N4500637248496627482.invokeNext();
        }
        return this.org$buni$meldware$mail$store$s3$S3FileStoreServiceUUIDImpl$getBuffer$aop(uUID, l, n);
    }

    public static class getBuffer_N450063724849662748
    extends MethodInvocation
    implements Untransformable {
        public UUID arg0;
        public long arg1;
        public int arg2;
        public S3FileStoreServiceUUIDImpl typedTargetObject;

        public getBuffer_N450063724849662748(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getBuffer_N450063724849662748(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getBuffer_N450063724849662748(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getBuffer_N450063724849662748() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$s3$S3FileStoreServiceUUIDImpl$getBuffer$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (UUID)object;
            this.arg1 = (Long)objectArray[1];
            this.arg2 = (Integer)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            new Integer(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            getBuffer_N450063724849662748 getBuffer_N4500637248496627482 = new getBuffer_N450063724849662748(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getBuffer_N4500637248496627482.arguments = this.arguments;
            ((InvocationBase)getBuffer_N4500637248496627482).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getBuffer_N4500637248496627482).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getBuffer_N4500637248496627482).instanceResolver = ((InvocationBase)this).instanceResolver;
            getBuffer_N4500637248496627482.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getBuffer_N4500637248496627482).targetObject = ((InvocationBase)this).targetObject;
            getBuffer_N4500637248496627482.arg0 = this.arg0;
            getBuffer_N4500637248496627482.arg1 = this.arg1;
            getBuffer_N4500637248496627482.arg2 = this.arg2;
            return getBuffer_N4500637248496627482;
        }
    }
}

