/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.userrepository.jaas;

import java.io.IOException;
import java.io.Serializable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.buni.meldware.mail.userrepository.jaas.JaasUserRepositoryMBean;
import org.jboss.logging.Logger;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.jboss.system.ServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

public class JaasUserRepository
extends ServiceMBeanSupport
implements ServiceMBean,
JaasUserRepositoryMBean,
Serializable {
    private static final long serialVersionUID = 3257562914868377396L;
    private static final Logger log = Logger.getLogger(JaasUserRepository.class);
    private String securityDomain;
    private String postmasterRole = "postmaster";
    private static ThreadLocal<String> apopKey;

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public String getPostmasterRole() {
        return this.postmasterRole;
    }

    public void setPostmasterRole(String role) {
        this.postmasterRole = role;
    }

    public boolean authenticateUser(String username, String password) {
        return this.test(username, password);
    }

    public boolean test(String username, String password, String apopkey) {
        log.debug((Object)("apop test called with username=" + username + ",pw=" + password + ",apopkey=" + apopkey));
        apopKey = new ThreadLocal();
        apopKey.set(apopkey);
        return this.login(username, password);
    }

    public boolean test(String username, String password) {
        return this.login(username, password);
    }

    private boolean login(String username, String password) {
        new MailCallback(username, password.toCharArray());
        try {
            LoginContext lc = new LoginContext(this.getSecurityDomain(), (CallbackHandler)new UsernamePasswordHandler(username, (Object)password));
            lc.login();
            try {
                lc.logout();
            }
            catch (Exception e) {
                log.trace((Object)e);
            }
            log.debug((Object)("Login by user " + username));
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Login failed for user " + username));
            log.trace((Object)e);
            return false;
        }
    }

    public String apopKey() {
        return apopKey.get();
    }

    public String getType() {
        return JaasUserRepository.class.getName();
    }

    private class MailCallback
    implements CallbackHandler {
        private String username;
        private char[] password;

        public MailCallback(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            int i = 0;
            while (i < callbacks.length) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(this.username);
                } else if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(this.password);
                } else {
                    throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback ");
                }
                ++i;
            }
        }
    }
}

