/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.CvPoint;
import org.bytedeco.opencv.opencv_core.CvPoint2D32f;
import org.bytedeco.opencv.opencv_core.CvPoint2D64f;
import org.bytedeco.opencv.presets.opencv_core;

@Properties(inherit={opencv_core.class})
public abstract class AbstractCvPoint
extends IntPointer {
    public static final CvPoint ZERO;

    public AbstractCvPoint(Pointer p) {
        super(p);
    }

    public abstract int x();

    public abstract CvPoint x(int var1);

    public abstract int y();

    public abstract CvPoint y(int var1);

    public CvPoint get(int[] pts) {
        return this.get(pts, 0, pts.length);
    }

    public CvPoint get(int[] pts, int offset, int length) {
        for (int i = 0; i < length / 2; ++i) {
            this.position(i);
            pts[offset + i * 2] = this.x();
            pts[offset + i * 2 + 1] = this.y();
        }
        return (CvPoint)this.position(0L);
    }

    public final CvPoint put(int[] pts, int offset, int length) {
        for (int i = 0; i < length / 2; ++i) {
            this.position(i);
            this.put(pts[offset + i * 2], pts[offset + i * 2 + 1]);
        }
        return (CvPoint)this.position(0L);
    }

    public final CvPoint put(int ... pts) {
        return this.put(pts, 0, pts.length);
    }

    public final CvPoint put(byte shift, double[] pts, int offset, int length) {
        int[] a = new int[length];
        for (int i = 0; i < length; ++i) {
            a[i] = (int)Math.round(pts[offset + i] * (double)(1 << shift));
        }
        return this.put(a, 0, length);
    }

    public final CvPoint put(byte shift, double ... pts) {
        return this.put(shift, pts, 0, pts.length);
    }

    public CvPoint put(int x, int y) {
        return this.x(x).y(y);
    }

    public CvPoint put(CvPoint o) {
        return this.x(o.x()).y(o.y());
    }

    public CvPoint put(byte shift, CvPoint2D32f o) {
        this.x(Math.round(o.x() * (float)(1 << shift)));
        this.y(Math.round(o.y() * (float)(1 << shift)));
        return (CvPoint)this;
    }

    public CvPoint put(byte shift, CvPoint2D64f o) {
        this.x((int)Math.round(o.x() * (double)(1 << shift)));
        this.y((int)Math.round(o.y() * (double)(1 << shift)));
        return (CvPoint)this;
    }

    public String toString() {
        if (this.isNull()) {
            return super.toString();
        }
        if (this.capacity() == 0L) {
            return "(" + this.x() + ", " + this.y() + ")";
        }
        String s = "";
        long p = this.position();
        for (long i = 0L; i < this.capacity(); ++i) {
            this.position(i);
            s = s + (i == 0L ? "(" : " (") + this.x() + ", " + this.y() + ")";
        }
        this.position(p);
        return s;
    }

    static {
        Loader.load();
        ZERO = new CvPoint().x(0).y(0);
    }
}

