/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.CvArr;
import org.bytedeco.opencv.opencv_core.CvMat;
import org.bytedeco.opencv.opencv_core.CvSize;
import org.bytedeco.opencv.opencv_core.IplImage;
import org.bytedeco.opencv.opencv_core.IplROI;

@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public abstract class AbstractIplImage
extends CvArr {
    protected BytePointer pointer;

    public AbstractIplImage(Pointer p) {
        super(p);
    }

    public static IplImage create(CvSize size, int depth, int channels) {
        IplImage i = opencv_core.cvCreateImage(size, depth, channels);
        if (i != null) {
            i.deallocator(new ReleaseDeallocator(i));
        }
        return i;
    }

    public static IplImage create(int width, int height, int depth, int channels) {
        return AbstractIplImage.create(opencv_core.cvSize(width, height), depth, channels);
    }

    public static IplImage create(CvSize size, int depth, int channels, int origin) {
        IplImage i = AbstractIplImage.create(size, depth, channels);
        if (i != null) {
            i.origin(origin);
        }
        return i;
    }

    public static IplImage create(int width, int height, int depth, int channels, int origin) {
        IplImage i = AbstractIplImage.create(width, height, depth, channels);
        if (i != null) {
            i.origin(origin);
        }
        return i;
    }

    public static IplImage createHeader(CvSize size, int depth, int channels) {
        IplImage i = opencv_core.cvCreateImageHeader(size, depth, channels);
        if (i != null) {
            i.deallocator(new HeaderReleaseDeallocator(i));
        }
        return i;
    }

    public static IplImage createHeader(int width, int height, int depth, int channels) {
        return AbstractIplImage.createHeader(opencv_core.cvSize(width, height), depth, channels);
    }

    public static IplImage createHeader(CvSize size, int depth, int channels, int origin) {
        IplImage i = AbstractIplImage.createHeader(size, depth, channels);
        if (i != null) {
            i.origin(origin);
        }
        return i;
    }

    public static IplImage createHeader(int width, int height, int depth, int channels, int origin) {
        IplImage i = AbstractIplImage.createHeader(width, height, depth, channels);
        if (i != null) {
            i.origin(origin);
        }
        return i;
    }

    public static IplImage create(int width, int height, int depth, int channels, Pointer data) {
        IplImage i = AbstractIplImage.createHeader(width, height, depth, channels);
        i.pointer = new BytePointer(data);
        i.imageData(i.pointer);
        return i;
    }

    public static IplImage createCompatible(IplImage template) {
        return AbstractIplImage.createIfNotCompatible(null, template);
    }

    public static IplImage createIfNotCompatible(IplImage image, IplImage template) {
        if (image == null || image.width() != template.width() || image.height() != template.height() || image.depth() != template.depth() || image.nChannels() != template.nChannels()) {
            image = AbstractIplImage.create(template.width(), template.height(), template.depth(), template.nChannels(), template.origin());
        }
        image.origin(template.origin());
        return image;
    }

    public IplImage clone() {
        IplImage i = opencv_core.cvCloneImage((IplImage)this);
        if (i != null) {
            i.deallocator(new ReleaseDeallocator(i));
        }
        return i;
    }

    public void release() {
        this.deallocate();
    }

    public abstract int nChannels();

    public abstract int depth();

    public abstract int origin();

    public abstract IplImage origin(int var1);

    public abstract int width();

    public abstract int height();

    public abstract IplROI roi();

    public abstract int imageSize();

    public abstract BytePointer imageData();

    public abstract int widthStep();

    @Override
    public int arrayChannels() {
        return this.nChannels();
    }

    @Override
    public int arrayDepth() {
        return this.depth();
    }

    @Override
    public int arrayOrigin() {
        return this.origin();
    }

    @Override
    public void arrayOrigin(int origin) {
        this.origin(origin);
    }

    @Override
    public int arrayWidth() {
        return this.width();
    }

    @Override
    public int arrayHeight() {
        return this.height();
    }

    @Override
    public IplROI arrayROI() {
        return this.roi();
    }

    @Override
    public long arraySize() {
        return this.imageSize();
    }

    @Override
    public BytePointer arrayData() {
        return this.imageData();
    }

    @Override
    public long arrayStep() {
        return this.widthStep();
    }

    public CvMat asCvMat() {
        CvMat mat = new CvMat();
        opencv_core.cvGetMat((CvArr)this, mat, (IntPointer)null, 0);
        return mat;
    }

    protected static class HeaderReleaseDeallocator
    extends IplImage
    implements Pointer.Deallocator {
        HeaderReleaseDeallocator(IplImage p) {
            super(p);
        }

        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            opencv_core.cvReleaseImageHeader(this);
            this.setNull();
        }
    }

    protected static class ReleaseDeallocator
    extends IplImage
    implements Pointer.Deallocator {
        ReleaseDeallocator(IplImage p) {
            super(p);
        }

        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            opencv_core.cvReleaseImage(this);
            this.setNull();
        }
    }
}

