/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.bioinspired;

import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.core.Size;

public class Retina
extends Algorithm {
    protected Retina(long addr) {
        super(addr);
    }

    public static Retina __fromPtr__(long addr) {
        return new Retina(addr);
    }

    public Mat getMagnoRAW() {
        return new Mat(Retina.getMagnoRAW_0(this.nativeObj));
    }

    public Mat getParvoRAW() {
        return new Mat(Retina.getParvoRAW_0(this.nativeObj));
    }

    public static Retina create(Size inputSize, boolean colorMode, int colorSamplingMethod, boolean useRetinaLogSampling, float reductionFactor, float samplingStrength) {
        return Retina.__fromPtr__(Retina.create_0(inputSize.width, inputSize.height, colorMode, colorSamplingMethod, useRetinaLogSampling, reductionFactor, samplingStrength));
    }

    public static Retina create(Size inputSize, boolean colorMode, int colorSamplingMethod, boolean useRetinaLogSampling, float reductionFactor) {
        return Retina.__fromPtr__(Retina.create_1(inputSize.width, inputSize.height, colorMode, colorSamplingMethod, useRetinaLogSampling, reductionFactor));
    }

    public static Retina create(Size inputSize, boolean colorMode, int colorSamplingMethod, boolean useRetinaLogSampling) {
        return Retina.__fromPtr__(Retina.create_2(inputSize.width, inputSize.height, colorMode, colorSamplingMethod, useRetinaLogSampling));
    }

    public static Retina create(Size inputSize, boolean colorMode, int colorSamplingMethod) {
        return Retina.__fromPtr__(Retina.create_3(inputSize.width, inputSize.height, colorMode, colorSamplingMethod));
    }

    public static Retina create(Size inputSize, boolean colorMode) {
        return Retina.__fromPtr__(Retina.create_4(inputSize.width, inputSize.height, colorMode));
    }

    public static Retina create(Size inputSize) {
        return Retina.__fromPtr__(Retina.create_5(inputSize.width, inputSize.height));
    }

    public Size getInputSize() {
        return new Size(Retina.getInputSize_0(this.nativeObj));
    }

    public Size getOutputSize() {
        return new Size(Retina.getOutputSize_0(this.nativeObj));
    }

    public String printSetup() {
        return Retina.printSetup_0(this.nativeObj);
    }

    public void activateContoursProcessing(boolean activate) {
        Retina.activateContoursProcessing_0(this.nativeObj, activate);
    }

    public void activateMovingContoursProcessing(boolean activate) {
        Retina.activateMovingContoursProcessing_0(this.nativeObj, activate);
    }

    public void applyFastToneMapping(Mat inputImage, Mat outputToneMappedImage) {
        Retina.applyFastToneMapping_0(this.nativeObj, inputImage.nativeObj, outputToneMappedImage.nativeObj);
    }

    public void clearBuffers() {
        Retina.clearBuffers_0(this.nativeObj);
    }

    public void getMagno(Mat retinaOutput_magno) {
        Retina.getMagno_0(this.nativeObj, retinaOutput_magno.nativeObj);
    }

    public void getMagnoRAW(Mat retinaOutput_magno) {
        Retina.getMagnoRAW_1(this.nativeObj, retinaOutput_magno.nativeObj);
    }

    public void getParvo(Mat retinaOutput_parvo) {
        Retina.getParvo_0(this.nativeObj, retinaOutput_parvo.nativeObj);
    }

    public void getParvoRAW(Mat retinaOutput_parvo) {
        Retina.getParvoRAW_1(this.nativeObj, retinaOutput_parvo.nativeObj);
    }

    public void run(Mat inputImage) {
        Retina.run_0(this.nativeObj, inputImage.nativeObj);
    }

    public void setColorSaturation(boolean saturateColors, float colorSaturationValue) {
        Retina.setColorSaturation_0(this.nativeObj, saturateColors, colorSaturationValue);
    }

    public void setColorSaturation(boolean saturateColors) {
        Retina.setColorSaturation_1(this.nativeObj, saturateColors);
    }

    public void setColorSaturation() {
        Retina.setColorSaturation_2(this.nativeObj);
    }

    public void setup(String retinaParameterFile, boolean applyDefaultSetupOnFailure) {
        Retina.setup_0(this.nativeObj, retinaParameterFile, applyDefaultSetupOnFailure);
    }

    public void setup(String retinaParameterFile) {
        Retina.setup_1(this.nativeObj, retinaParameterFile);
    }

    public void setup() {
        Retina.setup_2(this.nativeObj);
    }

    public void setupIPLMagnoChannel(boolean normaliseOutput, float parasolCells_beta, float parasolCells_tau, float parasolCells_k, float amacrinCellsTemporalCutFrequency, float V0CompressionParameter, float localAdaptintegration_tau, float localAdaptintegration_k) {
        Retina.setupIPLMagnoChannel_0(this.nativeObj, normaliseOutput, parasolCells_beta, parasolCells_tau, parasolCells_k, amacrinCellsTemporalCutFrequency, V0CompressionParameter, localAdaptintegration_tau, localAdaptintegration_k);
    }

    public void setupIPLMagnoChannel(boolean normaliseOutput, float parasolCells_beta, float parasolCells_tau, float parasolCells_k, float amacrinCellsTemporalCutFrequency, float V0CompressionParameter, float localAdaptintegration_tau) {
        Retina.setupIPLMagnoChannel_1(this.nativeObj, normaliseOutput, parasolCells_beta, parasolCells_tau, parasolCells_k, amacrinCellsTemporalCutFrequency, V0CompressionParameter, localAdaptintegration_tau);
    }

    public void setupIPLMagnoChannel(boolean normaliseOutput, float parasolCells_beta, float parasolCells_tau, float parasolCells_k, float amacrinCellsTemporalCutFrequency, float V0CompressionParameter) {
        Retina.setupIPLMagnoChannel_2(this.nativeObj, normaliseOutput, parasolCells_beta, parasolCells_tau, parasolCells_k, amacrinCellsTemporalCutFrequency, V0CompressionParameter);
    }

    public void setupIPLMagnoChannel(boolean normaliseOutput, float parasolCells_beta, float parasolCells_tau, float parasolCells_k, float amacrinCellsTemporalCutFrequency) {
        Retina.setupIPLMagnoChannel_3(this.nativeObj, normaliseOutput, parasolCells_beta, parasolCells_tau, parasolCells_k, amacrinCellsTemporalCutFrequency);
    }

    public void setupIPLMagnoChannel(boolean normaliseOutput, float parasolCells_beta, float parasolCells_tau, float parasolCells_k) {
        Retina.setupIPLMagnoChannel_4(this.nativeObj, normaliseOutput, parasolCells_beta, parasolCells_tau, parasolCells_k);
    }

    public void setupIPLMagnoChannel(boolean normaliseOutput, float parasolCells_beta, float parasolCells_tau) {
        Retina.setupIPLMagnoChannel_5(this.nativeObj, normaliseOutput, parasolCells_beta, parasolCells_tau);
    }

    public void setupIPLMagnoChannel(boolean normaliseOutput, float parasolCells_beta) {
        Retina.setupIPLMagnoChannel_6(this.nativeObj, normaliseOutput, parasolCells_beta);
    }

    public void setupIPLMagnoChannel(boolean normaliseOutput) {
        Retina.setupIPLMagnoChannel_7(this.nativeObj, normaliseOutput);
    }

    public void setupIPLMagnoChannel() {
        Retina.setupIPLMagnoChannel_8(this.nativeObj);
    }

    public void setupOPLandIPLParvoChannel(boolean colorMode, boolean normaliseOutput, float photoreceptorsLocalAdaptationSensitivity, float photoreceptorsTemporalConstant, float photoreceptorsSpatialConstant, float horizontalCellsGain, float HcellsTemporalConstant, float HcellsSpatialConstant, float ganglionCellsSensitivity) {
        Retina.setupOPLandIPLParvoChannel_0(this.nativeObj, colorMode, normaliseOutput, photoreceptorsLocalAdaptationSensitivity, photoreceptorsTemporalConstant, photoreceptorsSpatialConstant, horizontalCellsGain, HcellsTemporalConstant, HcellsSpatialConstant, ganglionCellsSensitivity);
    }

    public void setupOPLandIPLParvoChannel(boolean colorMode, boolean normaliseOutput, float photoreceptorsLocalAdaptationSensitivity, float photoreceptorsTemporalConstant, float photoreceptorsSpatialConstant, float horizontalCellsGain, float HcellsTemporalConstant, float HcellsSpatialConstant) {
        Retina.setupOPLandIPLParvoChannel_1(this.nativeObj, colorMode, normaliseOutput, photoreceptorsLocalAdaptationSensitivity, photoreceptorsTemporalConstant, photoreceptorsSpatialConstant, horizontalCellsGain, HcellsTemporalConstant, HcellsSpatialConstant);
    }

    public void setupOPLandIPLParvoChannel(boolean colorMode, boolean normaliseOutput, float photoreceptorsLocalAdaptationSensitivity, float photoreceptorsTemporalConstant, float photoreceptorsSpatialConstant, float horizontalCellsGain, float HcellsTemporalConstant) {
        Retina.setupOPLandIPLParvoChannel_2(this.nativeObj, colorMode, normaliseOutput, photoreceptorsLocalAdaptationSensitivity, photoreceptorsTemporalConstant, photoreceptorsSpatialConstant, horizontalCellsGain, HcellsTemporalConstant);
    }

    public void setupOPLandIPLParvoChannel(boolean colorMode, boolean normaliseOutput, float photoreceptorsLocalAdaptationSensitivity, float photoreceptorsTemporalConstant, float photoreceptorsSpatialConstant, float horizontalCellsGain) {
        Retina.setupOPLandIPLParvoChannel_3(this.nativeObj, colorMode, normaliseOutput, photoreceptorsLocalAdaptationSensitivity, photoreceptorsTemporalConstant, photoreceptorsSpatialConstant, horizontalCellsGain);
    }

    public void setupOPLandIPLParvoChannel(boolean colorMode, boolean normaliseOutput, float photoreceptorsLocalAdaptationSensitivity, float photoreceptorsTemporalConstant, float photoreceptorsSpatialConstant) {
        Retina.setupOPLandIPLParvoChannel_4(this.nativeObj, colorMode, normaliseOutput, photoreceptorsLocalAdaptationSensitivity, photoreceptorsTemporalConstant, photoreceptorsSpatialConstant);
    }

    public void setupOPLandIPLParvoChannel(boolean colorMode, boolean normaliseOutput, float photoreceptorsLocalAdaptationSensitivity, float photoreceptorsTemporalConstant) {
        Retina.setupOPLandIPLParvoChannel_5(this.nativeObj, colorMode, normaliseOutput, photoreceptorsLocalAdaptationSensitivity, photoreceptorsTemporalConstant);
    }

    public void setupOPLandIPLParvoChannel(boolean colorMode, boolean normaliseOutput, float photoreceptorsLocalAdaptationSensitivity) {
        Retina.setupOPLandIPLParvoChannel_6(this.nativeObj, colorMode, normaliseOutput, photoreceptorsLocalAdaptationSensitivity);
    }

    public void setupOPLandIPLParvoChannel(boolean colorMode, boolean normaliseOutput) {
        Retina.setupOPLandIPLParvoChannel_7(this.nativeObj, colorMode, normaliseOutput);
    }

    public void setupOPLandIPLParvoChannel(boolean colorMode) {
        Retina.setupOPLandIPLParvoChannel_8(this.nativeObj, colorMode);
    }

    public void setupOPLandIPLParvoChannel() {
        Retina.setupOPLandIPLParvoChannel_9(this.nativeObj);
    }

    public void write(String fs) {
        Retina.write_0(this.nativeObj, fs);
    }

    @Override
    protected void finalize() throws Throwable {
        Retina.delete(this.nativeObj);
    }

    private static native long getMagnoRAW_0(long var0);

    private static native long getParvoRAW_0(long var0);

    private static native long create_0(double var0, double var2, boolean var4, int var5, boolean var6, float var7, float var8);

    private static native long create_1(double var0, double var2, boolean var4, int var5, boolean var6, float var7);

    private static native long create_2(double var0, double var2, boolean var4, int var5, boolean var6);

    private static native long create_3(double var0, double var2, boolean var4, int var5);

    private static native long create_4(double var0, double var2, boolean var4);

    private static native long create_5(double var0, double var2);

    private static native double[] getInputSize_0(long var0);

    private static native double[] getOutputSize_0(long var0);

    private static native String printSetup_0(long var0);

    private static native void activateContoursProcessing_0(long var0, boolean var2);

    private static native void activateMovingContoursProcessing_0(long var0, boolean var2);

    private static native void applyFastToneMapping_0(long var0, long var2, long var4);

    private static native void clearBuffers_0(long var0);

    private static native void getMagno_0(long var0, long var2);

    private static native void getMagnoRAW_1(long var0, long var2);

    private static native void getParvo_0(long var0, long var2);

    private static native void getParvoRAW_1(long var0, long var2);

    private static native void run_0(long var0, long var2);

    private static native void setColorSaturation_0(long var0, boolean var2, float var3);

    private static native void setColorSaturation_1(long var0, boolean var2);

    private static native void setColorSaturation_2(long var0);

    private static native void setup_0(long var0, String var2, boolean var3);

    private static native void setup_1(long var0, String var2);

    private static native void setup_2(long var0);

    private static native void setupIPLMagnoChannel_0(long var0, boolean var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    private static native void setupIPLMagnoChannel_1(long var0, boolean var2, float var3, float var4, float var5, float var6, float var7, float var8);

    private static native void setupIPLMagnoChannel_2(long var0, boolean var2, float var3, float var4, float var5, float var6, float var7);

    private static native void setupIPLMagnoChannel_3(long var0, boolean var2, float var3, float var4, float var5, float var6);

    private static native void setupIPLMagnoChannel_4(long var0, boolean var2, float var3, float var4, float var5);

    private static native void setupIPLMagnoChannel_5(long var0, boolean var2, float var3, float var4);

    private static native void setupIPLMagnoChannel_6(long var0, boolean var2, float var3);

    private static native void setupIPLMagnoChannel_7(long var0, boolean var2);

    private static native void setupIPLMagnoChannel_8(long var0);

    private static native void setupOPLandIPLParvoChannel_0(long var0, boolean var2, boolean var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

    private static native void setupOPLandIPLParvoChannel_1(long var0, boolean var2, boolean var3, float var4, float var5, float var6, float var7, float var8, float var9);

    private static native void setupOPLandIPLParvoChannel_2(long var0, boolean var2, boolean var3, float var4, float var5, float var6, float var7, float var8);

    private static native void setupOPLandIPLParvoChannel_3(long var0, boolean var2, boolean var3, float var4, float var5, float var6, float var7);

    private static native void setupOPLandIPLParvoChannel_4(long var0, boolean var2, boolean var3, float var4, float var5, float var6);

    private static native void setupOPLandIPLParvoChannel_5(long var0, boolean var2, boolean var3, float var4, float var5);

    private static native void setupOPLandIPLParvoChannel_6(long var0, boolean var2, boolean var3, float var4);

    private static native void setupOPLandIPLParvoChannel_7(long var0, boolean var2, boolean var3);

    private static native void setupOPLandIPLParvoChannel_8(long var0, boolean var2);

    private static native void setupOPLandIPLParvoChannel_9(long var0);

    private static native void write_0(long var0, String var2);

    private static native void delete(long var0);
}

