/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.ProcessApplication;
import org.camunda.bpm.application.impl.ProcessApplicationLogger;
import org.camunda.bpm.application.impl.ServletProcessApplication;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;

@HandlesTypes(value={ProcessApplication.class})
public class ServletProcessApplicationDeployer
implements ServletContainerInitializer {
    private static ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        if (c == null || c.isEmpty()) {
            return;
        }
        if (c.contains(ProcessApplication.class)) {
            c = new HashSet(c);
            c.remove(ProcessApplication.class);
        }
        String contextPath = ctx.getContextPath();
        if (c.size() > 1) {
            throw LOG.multiplePasException(c, contextPath);
        }
        if (c.size() == 1) {
            Class<?> paClass = c.iterator().next();
            if (!AbstractProcessApplication.class.isAssignableFrom(paClass)) {
                throw LOG.paWrongTypeException(paClass);
            }
            if (ServletProcessApplication.class.isAssignableFrom(paClass)) {
                LOG.detectedPa(paClass);
                ctx.addListener(paClass.getName());
            }
        } else {
            LOG.servletDeployerNoPaFound(contextPath);
        }
    }
}

