/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.metadata;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.application.impl.metadata.ProcessArchiveXmlImpl;
import org.camunda.bpm.application.impl.metadata.ProcessesXmlImpl;
import org.camunda.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import org.camunda.bpm.application.impl.metadata.spi.ProcessesXml;
import org.camunda.bpm.container.impl.metadata.DeploymentMetadataParse;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEngineXml;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.impl.util.xml.Parser;

public class ProcessesXmlParse
extends DeploymentMetadataParse {
    protected ProcessesXml processesXml;

    public ProcessesXmlParse(Parser parser) {
        super(parser);
    }

    @Override
    public ProcessesXmlParse execute() {
        super.execute();
        return this;
    }

    @Override
    protected void parseRootElement() {
        ArrayList<ProcessEngineXml> processEngines = new ArrayList<ProcessEngineXml>();
        ArrayList<ProcessArchiveXml> processArchives = new ArrayList<ProcessArchiveXml>();
        for (Element element : this.rootElement.elements()) {
            if ("process-engine".equals(element.getTagName())) {
                this.parseProcessEngine(element, processEngines);
                continue;
            }
            if (!"process-archive".equals(element.getTagName())) continue;
            this.parseProcessArchive(element, processArchives);
        }
        this.processesXml = new ProcessesXmlImpl(processEngines, processArchives);
    }

    protected void parseProcessArchive(Element element, List<ProcessArchiveXml> parsedProcessArchives) {
        ProcessArchiveXmlImpl processArchive = new ProcessArchiveXmlImpl();
        processArchive.setName(element.attribute("name"));
        processArchive.setTenantId(element.attribute("tenantId"));
        ArrayList<String> processResourceNames = new ArrayList<String>();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Element childElement : element.elements()) {
            if ("process-engine".equals(childElement.getTagName())) {
                processArchive.setProcessEngineName(childElement.getText());
                continue;
            }
            if ("process".equals(childElement.getTagName()) || "resource".equals(childElement.getTagName())) {
                processResourceNames.add(childElement.getText());
                continue;
            }
            if (!"properties".equals(childElement.getTagName())) continue;
            this.parseProperties(childElement, properties);
        }
        processArchive.setProperties(properties);
        processArchive.setProcessResourceNames(processResourceNames);
        parsedProcessArchives.add(processArchive);
    }

    public ProcessesXml getProcessesXml() {
        return this.processesXml;
    }

    @Override
    public ProcessesXmlParse sourceUrl(URL url) {
        super.sourceUrl(url);
        return this;
    }
}

