/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.HistoryLevelSetupCommand;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;

public class DetermineHistoryLevelCmd
implements Command<HistoryLevel> {
    private final List<HistoryLevel> historyLevels;

    public DetermineHistoryLevelCmd(List<HistoryLevel> historyLevels) {
        this.historyLevels = historyLevels;
    }

    @Override
    public HistoryLevel execute(CommandContext commandContext) {
        Integer databaseHistoryLevel = HistoryLevelSetupCommand.databaseHistoryLevel(commandContext);
        HistoryLevel result = null;
        if (databaseHistoryLevel != null) {
            for (HistoryLevel historyLevel : this.historyLevels) {
                if (historyLevel.getId() != databaseHistoryLevel.intValue()) continue;
                result = historyLevel;
                break;
            }
            if (result != null) {
                return result;
            }
            throw new ProcessEngineException(String.format("The configured history level with id='%s' is not registered in this config.", databaseHistoryLevel));
        }
        return null;
    }
}

