/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.IsTelemetryEnabledCmd;
import org.camunda.bpm.engine.impl.cmd.SetPropertyCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.telemetry.TelemetryLogger;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.impl.util.TelemetryUtil;

public class TelemetryConfigureCmd
implements Command<Void> {
    protected static final TelemetryLogger LOG = ProcessEngineLogger.TELEMETRY_LOGGER;
    protected static final String TELEMETRY_PROPERTY = "camunda.telemetry.enabled";
    protected boolean telemetryEnabled;

    public TelemetryConfigureCmd(boolean telemetryEnabled) {
        this.telemetryEnabled = telemetryEnabled;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCamundaAdminOrPermission(CommandChecker::checkConfigureTelemetry);
        commandContext.runWithoutAuthorization(() -> {
            this.toggleTelemetry(commandContext);
            return null;
        });
        return null;
    }

    protected void toggleTelemetry(CommandContext commandContext) {
        Boolean currentValue = new IsTelemetryEnabledCmd().execute(commandContext);
        new SetPropertyCmd(TELEMETRY_PROPERTY, Boolean.toString(this.telemetryEnabled)).execute(commandContext);
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        boolean isReportedActivated = processEngineConfiguration.isTelemetryReporterActivate();
        TelemetryReporter telemetryReporter = processEngineConfiguration.getTelemetryReporter();
        if ((currentValue == null || !currentValue.booleanValue() && this.telemetryEnabled) && isReportedActivated) {
            telemetryReporter.reschedule();
        }
        TelemetryUtil.toggleLocalTelemetry(this.telemetryEnabled, processEngineConfiguration.getTelemetryRegistry(), processEngineConfiguration.getMetricsRegistry());
    }
}

