/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.impl.core.variable.mapping.InputParameter;
import org.camunda.bpm.engine.impl.core.variable.mapping.OutputParameter;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;

public class IoMapping {
    protected List<InputParameter> inputParameters;
    protected List<OutputParameter> outputParameters;

    public void executeInputParameters(AbstractVariableScope variableScope) {
        for (InputParameter inputParameter : this.getInputParameters()) {
            inputParameter.execute(variableScope);
        }
    }

    public void executeOutputParameters(AbstractVariableScope variableScope) {
        for (OutputParameter outputParameter : this.getOutputParameters()) {
            outputParameter.execute(variableScope);
        }
    }

    public void addInputParameter(InputParameter param) {
        if (this.inputParameters == null) {
            this.inputParameters = new ArrayList<InputParameter>();
        }
        this.inputParameters.add(param);
    }

    public void addOutputParameter(OutputParameter param) {
        if (this.outputParameters == null) {
            this.outputParameters = new ArrayList<OutputParameter>();
        }
        this.outputParameters.add(param);
    }

    public List<InputParameter> getInputParameters() {
        if (this.inputParameters == null) {
            return Collections.emptyList();
        }
        return this.inputParameters;
    }

    public void setInputParameters(List<InputParameter> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public List<OutputParameter> getOutputParameters() {
        if (this.outputParameters == null) {
            return Collections.emptyList();
        }
        return this.outputParameters;
    }

    public void setOuputParameters(List<OutputParameter> outputParameters) {
        this.outputParameters = outputParameters;
    }
}

