/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instruction;

import org.camunda.bpm.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class SameEventTypeValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        String targetType;
        String sourceType;
        ActivityImpl sourceActivity = instruction.getSourceActivity();
        ActivityImpl targetActivity = instruction.getTargetActivity();
        if (this.isEvent(sourceActivity) && this.isEvent(targetActivity) && !(sourceType = sourceActivity.getProperties().get(BpmnProperties.TYPE)).equals(targetType = targetActivity.getProperties().get(BpmnProperties.TYPE))) {
            report.addFailure("Events are not of the same type (" + sourceType + " != " + targetType + ")");
        }
    }

    protected boolean isEvent(ActivityImpl activity) {
        ActivityBehavior behavior = activity.getActivityBehavior();
        return behavior instanceof BoundaryEventActivityBehavior || behavior instanceof EventSubProcessStartEventActivityBehavior;
    }
}

