/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl.type.reference;

import org.camunda.bpm.model.xml.ModelException;
import org.camunda.bpm.model.xml.ModelReferenceException;
import org.camunda.bpm.model.xml.impl.ModelInstanceImpl;
import org.camunda.bpm.model.xml.impl.instance.ModelElementInstanceImpl;
import org.camunda.bpm.model.xml.impl.type.reference.ElementReferenceCollectionImpl;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.child.ChildElement;
import org.camunda.bpm.model.xml.type.reference.ElementReference;

public class ElementReferenceImpl<Target extends ModelElementInstance, Source extends ModelElementInstance>
extends ElementReferenceCollectionImpl<Target, Source>
implements ElementReference<Target, Source> {
    public ElementReferenceImpl(ChildElement<Source> referenceSourceCollection) {
        super(referenceSourceCollection);
    }

    private ChildElement<Source> getReferenceSourceChild() {
        return (ChildElement)this.getReferenceSourceCollection();
    }

    @Override
    public Source getReferenceSource(ModelElementInstance referenceSourceParent) {
        return this.getReferenceSourceChild().getChild(referenceSourceParent);
    }

    private void setReferenceSource(ModelElementInstance referenceSourceParent, Source referenceSource) {
        this.getReferenceSourceChild().setChild(referenceSourceParent, referenceSource);
    }

    @Override
    public Target getReferenceTargetElement(ModelElementInstanceImpl referenceSourceParentElement) {
        Source referenceSource = this.getReferenceSource(referenceSourceParentElement);
        if (referenceSource != null) {
            String identifier = this.getReferenceIdentifier((ModelElementInstance)referenceSource);
            Object referenceTargetElement = referenceSourceParentElement.getModelInstance().getModelElementById(identifier);
            if (referenceTargetElement != null) {
                return (Target)referenceTargetElement;
            }
            throw new ModelException("Unable to find a model element instance for id " + identifier);
        }
        return null;
    }

    @Override
    public void setReferenceTargetElement(ModelElementInstanceImpl referenceSourceParentElement, Target referenceTargetElement) {
        String identifier;
        ModelInstanceImpl modelInstance = referenceSourceParentElement.getModelInstance();
        Object existingElement = modelInstance.getModelElementById(identifier = (String)this.referenceTargetAttribute.getValue((ModelElementInstance)referenceTargetElement));
        if (existingElement == null || !existingElement.equals(referenceTargetElement)) {
            throw new ModelReferenceException("Cannot create reference to model element " + referenceTargetElement + ": element is not part of model. Please connect element to the model first.");
        }
        Object referenceSourceElement = modelInstance.newInstance(this.getReferenceSourceElementType());
        this.setReferenceSource(referenceSourceParentElement, referenceSourceElement);
        this.setReferenceIdentifier((ModelElementInstance)referenceSourceElement, identifier);
    }

    @Override
    public void clearReferenceTargetElement(ModelElementInstanceImpl referenceSourceParentElement) {
        this.getReferenceSourceChild().removeChild(referenceSourceParentElement);
    }
}

