/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.test.assertions;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;
import org.camunda.bpm.model.xml.type.attribute.Attribute;
import org.camunda.bpm.model.xml.type.reference.Reference;

public class AttributeAssert
extends AbstractAssert<AttributeAssert, Attribute<?>> {
    private final String attributeName;

    protected AttributeAssert(Attribute<?> actual) {
        super(actual, AttributeAssert.class);
        this.attributeName = actual.getAttributeName();
    }

    public AttributeAssert isRequired() {
        this.isNotNull();
        if (!((Attribute)this.actual).isRequired()) {
            this.failWithMessage("Expected attribute <%s> to be required but was not", new Object[]{this.attributeName});
        }
        return this;
    }

    public AttributeAssert isOptional() {
        this.isNotNull();
        if (((Attribute)this.actual).isRequired()) {
            this.failWithMessage("Expected attribute <%s> to be optional but was required", new Object[]{this.attributeName});
        }
        return this;
    }

    public AttributeAssert isIdAttribute() {
        this.isNotNull();
        if (!((Attribute)this.actual).isIdAttribute()) {
            this.failWithMessage("Expected attribute <%s> to be an ID attribute but was not", new Object[]{this.attributeName});
        }
        return this;
    }

    public AttributeAssert isNotIdAttribute() {
        this.isNotNull();
        if (((Attribute)this.actual).isIdAttribute()) {
            this.failWithMessage("Expected attribute <%s> to be not an ID attribute but was", new Object[]{this.attributeName});
        }
        return this;
    }

    public AttributeAssert hasDefaultValue(Object defaultValue) {
        this.isNotNull();
        Object actualDefaultValue = ((Attribute)this.actual).getDefaultValue();
        if (!defaultValue.equals(actualDefaultValue)) {
            this.failWithMessage("Expected attribute <%s> to have default value <%s> but was <%s>", new Object[]{this.attributeName, defaultValue, actualDefaultValue});
        }
        return this;
    }

    public AttributeAssert hasNoDefaultValue() {
        this.isNotNull();
        Object actualDefaultValue = ((Attribute)this.actual).getDefaultValue();
        if (actualDefaultValue != null) {
            this.failWithMessage("Expected attribute <%s> to have no default value but was <%s>", new Object[]{this.attributeName, actualDefaultValue});
        }
        return this;
    }

    public AttributeAssert hasOwningElementType(ModelElementType owningElementType) {
        this.isNotNull();
        ModelElementType actualOwningElementType = ((Attribute)this.actual).getOwningElementType();
        if (!owningElementType.equals(actualOwningElementType)) {
            this.failWithMessage("Expected attribute <%s> to have owning element type <%s> but was <%s>", new Object[]{this.attributeName, owningElementType, actualOwningElementType});
        }
        return this;
    }

    public AttributeAssert hasValue(ModelElementInstance modelElementInstance) {
        this.isNotNull();
        Object actualValue = ((Attribute)this.actual).getValue(modelElementInstance);
        if (actualValue == null) {
            this.failWithMessage("Expected attribute <%s> to have a value but has not", new Object[]{this.attributeName});
        }
        return this;
    }

    public AttributeAssert hasValue(ModelElementInstance modelElementInstance, Object value) {
        this.isNotNull();
        Object actualValue = ((Attribute)this.actual).getValue(modelElementInstance);
        if (!value.equals(actualValue)) {
            this.failWithMessage("Expected attribute <%s> to have value <%s> but was <%s>", new Object[]{this.attributeName, value, actualValue});
        }
        return this;
    }

    public AttributeAssert hasNoValue(ModelElementInstance modelElementInstance) {
        this.isNotNull();
        Object actualValue = ((Attribute)this.actual).getValue(modelElementInstance);
        if (actualValue != null) {
            this.failWithMessage("Expected attribute <%s> to have no value but was <%s>", new Object[]{this.attributeName, actualValue});
        }
        return this;
    }

    public AttributeAssert hasAttributeName(String attributeName) {
        this.isNotNull();
        if (!attributeName.equals(this.attributeName)) {
            this.failWithMessage("Expected attribute to have attribute name <%s> but was <%s>", new Object[]{attributeName, this.attributeName});
        }
        return this;
    }

    public AttributeAssert hasNamespaceUri(String namespaceUri) {
        this.isNotNull();
        String actualNamespaceUri1 = ((Attribute)this.actual).getNamespaceUri();
        if (!namespaceUri.equals(actualNamespaceUri1)) {
            this.failWithMessage("Expected attribute <%s> to have namespace URI <%s> but was <%s>", new Object[]{this.attributeName, namespaceUri, actualNamespaceUri1});
        }
        return this;
    }

    public AttributeAssert hasNoNamespaceUri() {
        this.isNotNull();
        String actualNamespaceUri = ((Attribute)this.actual).getNamespaceUri();
        if (actualNamespaceUri != null) {
            this.failWithMessage("Expected attribute <%s> to have no namespace URI but was <%s>", new Object[]{this.attributeName, actualNamespaceUri});
        }
        return this;
    }

    public AttributeAssert hasIncomingReferences() {
        this.isNotNull();
        List<Reference<?>> actualIncomingReferences = ((Attribute)this.actual).getIncomingReferences();
        if (actualIncomingReferences.isEmpty()) {
            this.failWithMessage("Expected attribute <%s> to have incoming references but has not", new Object[]{this.attributeName});
        }
        return this;
    }

    public AttributeAssert hasIncomingReferences(Reference<?> ... references) {
        this.isNotNull();
        List<Reference<?>> incomingReferences = Arrays.asList(references);
        List<Reference<Reference<?>>> actualIncomingReferences = ((Attribute)this.actual).getIncomingReferences();
        if (!actualIncomingReferences.containsAll(incomingReferences)) {
            this.failWithMessage("Expected attribute <%s> to have incoming references <%s> but has <%s>", new Object[]{this.attributeName, incomingReferences, actualIncomingReferences});
        }
        return this;
    }

    public AttributeAssert hasNoIncomingReferences() {
        this.isNotNull();
        List<Reference<?>> actualIncomingReferences = ((Attribute)this.actual).getIncomingReferences();
        if (!actualIncomingReferences.isEmpty()) {
            this.failWithMessage("Expected attribute <%s> to have no incoming references but has <%s>", new Object[]{this.attributeName, actualIncomingReferences});
        }
        return this;
    }

    public AttributeAssert hasOutgoingReferences() {
        this.isNotNull();
        List<Reference<?>> actualOutgoingReferences = ((Attribute)this.actual).getOutgoingReferences();
        if (actualOutgoingReferences.isEmpty()) {
            this.failWithMessage("Expected attribute <%s> to have outgoing references but has not", new Object[]{this.attributeName});
        }
        return this;
    }

    public AttributeAssert hasOutgoingReferences(Reference<?> ... references) {
        this.isNotNull();
        List<Reference<?>> outgoingReferences = Arrays.asList(references);
        List<Reference<Reference<?>>> actualOutgoingReferences = ((Attribute)this.actual).getOutgoingReferences();
        if (!actualOutgoingReferences.containsAll(outgoingReferences)) {
            this.failWithMessage("Expected attribute <%s> to have outgoing references <%s> but has <%s>", new Object[]{this.attributeName, outgoingReferences, actualOutgoingReferences});
        }
        return this;
    }

    public AttributeAssert hasNoOutgoingReferences() {
        this.isNotNull();
        List<Reference<?>> actualOutgoingReferences = ((Attribute)this.actual).getOutgoingReferences();
        if (!actualOutgoingReferences.isEmpty()) {
            this.failWithMessage("Expected attribute <%s> to have no outgoing references but has <%s>", new Object[]{this.attributeName, actualOutgoingReferences});
        }
        return this;
    }
}

