/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.util;

import javax.servlet.ServletContext;

public class ServletContextUtil {
    protected static final String APP_PATH_ATTR_NAME = "org.camunda.bpm.spring.boot.starter.webapp.applicationPath";
    protected static final String SUCCESSFUL_ET_ATTR_NAME = "org.camunda.bpm.webapp.telemetry.data.stored";

    public static String getAppPath(ServletContext servletContext) {
        String applicationPath = (String)servletContext.getAttribute(APP_PATH_ATTR_NAME);
        if (applicationPath == null) {
            return "";
        }
        return applicationPath;
    }

    public static void setAppPath(String applicationPath, ServletContext servletContext) {
        servletContext.setAttribute(APP_PATH_ATTR_NAME, (Object)applicationPath);
    }

    public static boolean isTelemetryDataSentAlready(String webappName, String engineName, ServletContext servletContext) {
        return servletContext.getAttribute(ServletContextUtil.buildTelemetrySentAttribute(webappName, engineName)) != null;
    }

    public static void setTelemetryDataSent(String webappName, String engineName, ServletContext servletContext) {
        servletContext.setAttribute(ServletContextUtil.buildTelemetrySentAttribute(webappName, engineName), (Object)true);
    }

    protected static String buildTelemetrySentAttribute(String webappName, String engineName) {
        return "org.camunda.bpm.webapp.telemetry.data.stored." + webappName + "." + engineName;
    }
}

