/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class AccumulatorPathVisitor
extends CountingPathVisitor {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Path> dirList = new ArrayList<Path>();
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Path> fileList = new ArrayList<Path>();

    public static @UnknownKeyFor @NonNull @Initialized AccumulatorPathVisitor withBigIntegerCounters() {
        return new AccumulatorPathVisitor(Counters.bigIntegerPathCounters());
    }

    public static @UnknownKeyFor @NonNull @Initialized AccumulatorPathVisitor withLongCounters() {
        return new AccumulatorPathVisitor(Counters.longPathCounters());
    }

    public AccumulatorPathVisitor(@UnknownKeyFor @NonNull @Initialized Counters.PathCounters pathCounter) {
        super(pathCounter);
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AccumulatorPathVisitor)) {
            return false;
        }
        AccumulatorPathVisitor other = (AccumulatorPathVisitor)obj;
        return Objects.equals(this.dirList, other.dirList) && Objects.equals(this.fileList, other.fileList);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Path> getDirList() {
        return this.dirList;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Path> getFileList() {
        return this.fileList;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.dirList, this.fileList);
        return result;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Path> relativizeDirectories(@UnknownKeyFor @NonNull @Initialized Path parent, @UnknownKeyFor @NonNull @Initialized boolean sort, @Nullable @UnknownKeyFor @Initialized Comparator<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Path> comparator) {
        return PathUtils.relativize(this.getDirList(), parent, sort, comparator);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Path> relativizeFiles(@UnknownKeyFor @NonNull @Initialized Path parent, @UnknownKeyFor @NonNull @Initialized boolean sort, @Nullable @UnknownKeyFor @Initialized Comparator<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Path> comparator) {
        return PathUtils.relativize(this.getFileList(), parent, sort, comparator);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FileVisitResult visitFile(@UnknownKeyFor @NonNull @Initialized Path file, @UnknownKeyFor @NonNull @Initialized BasicFileAttributes attributes) throws @UnknownKeyFor @NonNull @Initialized IOException {
        (Files.isDirectory(file, new LinkOption[0]) ? this.dirList : this.fileList).add(file.normalize());
        return super.visitFile(file, attributes);
    }
}

