/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SequenceReader
extends Reader {
    private @Nullable @UnknownKeyFor @Initialized Reader reader;
    private @Nullable @UnknownKeyFor @Initialized Iterator<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Reader> readers;

    @EnsuresNonNull(value={"this.readers"})
    public SequenceReader(@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Reader> readers) {
        this.readers = Objects.requireNonNull(readers, "readers").iterator();
        this.reader = this.nextReader();
    }

    public SequenceReader(Reader ... readers) {
        this(Arrays.asList(readers));
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.readers = null;
        this.reader = null;
    }

    @RequiresNonNull(value={"this.readers"})
    @EnsuresNonNull(value={"this.readers"})
    private @Nullable @UnknownKeyFor @Initialized Reader nextReader(@UnknownInitialization(value=SequenceReader.class) SequenceReader this) {
        return this.readers.hasNext() ? this.readers.next() : null;
    }

    @Override
    @RequiresNonNull(value={"this.readers"})
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        int c = -1;
        while (this.reader != null && (c = this.reader.read()) == -1) {
            this.reader = this.nextReader();
        }
        return c;
    }

    @Override
    @RequiresNonNull(value={"this.readers", "this.reader"})
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] cbuf, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(cbuf, "cbuf");
        if (len < 0 || off < 0 || off + len > cbuf.length) {
            throw new IndexOutOfBoundsException("Array Size=" + cbuf.length + ", offset=" + off + ", length=" + len);
        }
        int count = 0;
        while (this.reader != null) {
            int readLen = this.reader.read(cbuf, off, len);
            if (readLen == -1) {
                this.reader = this.nextReader();
                continue;
            }
            count += readLen;
            off += readLen;
            if ((len -= readLen) > 0) continue;
            break;
        }
        if (count > 0) {
            return count;
        }
        return -1;
    }
}

