/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.util.regex.Pattern;
import org.apache.commons.io.serialization.ClassNameMatcher;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class RegexpClassNameMatcher
implements ClassNameMatcher {
    private final @UnknownKeyFor @NonNull @Initialized Pattern pattern;

    public RegexpClassNameMatcher(@UnknownKeyFor @NonNull @Initialized String regex) {
        this(Pattern.compile(regex));
    }

    public RegexpClassNameMatcher(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Null pattern");
        }
        this.pattern = pattern;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized String className) {
        return this.pattern.matcher(className).matches();
    }
}

