package org.checkerframework.checker.tainting.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.checkerframework.qualframework.poly.qual.DefaultValue;

/**
 * A polymorphic qualifier for the Tainting type system.
 *
 * @checker_framework.manual #tainting-checker Tainting Checker
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@Repeatable(MultiPolyTainted.class)
public @interface PolyTainted {
    /**
     * The name of the qualifier parameter to set.
     */
    String param() default DefaultValue.PRIMARY_TARGET;
}
