/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclint;

import com.sun.tools.javac.util.StringUtils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Name;

public enum HtmlTag {
    A(BlockType.INLINE, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.OK, Attr.HREF, Attr.TARGET, Attr.NAME)),
    B(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    BIG(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    BLOCKQUOTE(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    BODY(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    BR(BlockType.INLINE, EndKind.NONE, HtmlTag.attrs(AttrKind.USE_CSS, Attr.CLEAR)),
    CAPTION(BlockType.TABLE_ITEM, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_INLINE, Flag.EXPECT_CONTENT), new AttrMap[0]),
    CENTER(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    CITE(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    CODE(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    DD(BlockType.LIST_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE, Flag.EXPECT_CONTENT), new AttrMap[0]),
    DFN(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    DIV(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    DL(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.USE_CSS, Attr.COMPACT)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == DT || t == DD;
        }
    }
    ,
    DT(BlockType.LIST_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_INLINE, Flag.EXPECT_CONTENT), new AttrMap[0]),
    EM(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.NO_NEST), new AttrMap[0]),
    FONT(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), HtmlTag.attrs(AttrKind.USE_CSS, Attr.SIZE, Attr.COLOR, Attr.FACE)),
    FRAME(BlockType.OTHER, EndKind.NONE, new AttrMap[0]),
    FRAMESET(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    H1(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]),
    H2(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]),
    H3(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]),
    H4(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]),
    H5(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]),
    H6(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]),
    HEAD(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    HR(BlockType.BLOCK, EndKind.NONE, HtmlTag.attrs(AttrKind.OK, Attr.WIDTH)),
    HTML(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    I(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    IMG(BlockType.INLINE, EndKind.NONE, HtmlTag.attrs(AttrKind.OK, Attr.SRC, Attr.ALT, Attr.HEIGHT, Attr.WIDTH), HtmlTag.attrs(AttrKind.OBSOLETE, Attr.NAME), HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN, Attr.HSPACE, Attr.VSPACE, Attr.BORDER)),
    LI(BlockType.LIST_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), HtmlTag.attrs(AttrKind.OK, Attr.VALUE)),
    LINK(BlockType.OTHER, EndKind.NONE, new AttrMap[0]),
    MENU(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == LI;
        }
    }
    ,
    META(BlockType.OTHER, EndKind.NONE, new AttrMap[0]),
    NOFRAMES(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    NOSCRIPT(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]),
    OL(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.OK, Attr.START, Attr.TYPE)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == LI;
        }
    }
    ,
    P(BlockType.BLOCK, EndKind.OPTIONAL, EnumSet.of(Flag.EXPECT_CONTENT), HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN)),
    PRE(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]){

        @Override
        public boolean accepts(HtmlTag t) {
            switch (t) {
                case IMG: 
                case BIG: 
                case SMALL: 
                case SUB: 
                case SUP: {
                    return false;
                }
            }
            return t.blockType == BlockType.INLINE;
        }
    }
    ,
    SCRIPT(BlockType.OTHER, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.OK, Attr.SRC)),
    SMALL(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    SPAN(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    STRONG(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    SUB(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    SUP(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    TABLE(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.OK, Attr.SUMMARY, Attr.FRAME, Attr.RULES, Attr.BORDER, Attr.CELLPADDING, Attr.CELLSPACING, Attr.WIDTH), HtmlTag.attrs(AttrKind.USE_CSS, Attr.ALIGN, Attr.BGCOLOR)}){

        @Override
        public boolean accepts(HtmlTag t) {
            switch (t) {
                case CAPTION: 
                case THEAD: 
                case TBODY: 
                case TFOOT: 
                case TR: {
                    return true;
                }
            }
            return false;
        }
    }
    ,
    TBODY(BlockType.TABLE_ITEM, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.OK, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.VALIGN)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == TR;
        }
    }
    ,
    TD(BlockType.TABLE_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), HtmlTag.attrs(AttrKind.OK, Attr.COLSPAN, Attr.ROWSPAN, Attr.HEADERS, Attr.SCOPE, Attr.ABBR, Attr.AXIS, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.VALIGN), HtmlTag.attrs(AttrKind.USE_CSS, Attr.WIDTH, Attr.BGCOLOR, Attr.HEIGHT, Attr.NOWRAP)),
    TFOOT(BlockType.TABLE_ITEM, EndKind.REQUIRED, new AttrMap[]{HtmlTag.attrs(AttrKind.OK, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.VALIGN)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == TR;
        }
    }
    ,
    TH(BlockType.TABLE_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), HtmlTag.attrs(AttrKind.OK, Attr.COLSPAN, Attr.ROWSPAN, Attr.HEADERS, Attr.SCOPE, Attr.ABBR, Attr.AXIS, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.VALIGN), HtmlTag.attrs(AttrKind.USE_CSS, Attr.WIDTH, Attr.BGCOLOR, Attr.HEIGHT, Attr.NOWRAP)),
    THEAD(BlockType.TABLE_ITEM, EndKind.REQUIRED, new AttrMap[]{HtmlTag.attrs(AttrKind.OK, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.VALIGN)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == TR;
        }
    }
    ,
    TITLE(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    TR(BlockType.TABLE_ITEM, EndKind.OPTIONAL, new AttrMap[]{HtmlTag.attrs(AttrKind.OK, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.VALIGN), HtmlTag.attrs(AttrKind.USE_CSS, Attr.BGCOLOR)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == TH || t == TD;
        }
    }
    ,
    TT(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    U(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    UL(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.OK, Attr.COMPACT, Attr.TYPE)}){

        @Override
        public boolean accepts(HtmlTag t) {
            return t == LI;
        }
    }
    ,
    VAR(BlockType.INLINE, EndKind.REQUIRED, new AttrMap[0]);

    public final BlockType blockType;
    public final EndKind endKind;
    public final Set<Flag> flags;
    private final Map<Attr, AttrKind> attrs;
    private static final Map<String, HtmlTag> index;

    private HtmlTag(BlockType blockType, EndKind endKind, AttrMap ... attrMaps) {
        this(blockType, endKind, Collections.emptySet(), attrMaps);
    }

    private HtmlTag(BlockType blockType, EndKind endKind, Set<Flag> flags, AttrMap ... attrMaps) {
        this.blockType = blockType;
        this.endKind = endKind;
        this.flags = flags;
        this.attrs = new EnumMap<Attr, AttrKind>(Attr.class);
        for (AttrMap m : attrMaps) {
            this.attrs.putAll(m);
        }
        this.attrs.put(Attr.CLASS, AttrKind.OK);
        this.attrs.put(Attr.ID, AttrKind.OK);
        this.attrs.put(Attr.STYLE, AttrKind.OK);
    }

    public boolean accepts(HtmlTag t) {
        if (this.flags.contains((Object)Flag.ACCEPTS_BLOCK) && this.flags.contains((Object)Flag.ACCEPTS_INLINE)) {
            return t.blockType == BlockType.BLOCK || t.blockType == BlockType.INLINE;
        }
        if (this.flags.contains((Object)Flag.ACCEPTS_BLOCK)) {
            return t.blockType == BlockType.BLOCK;
        }
        if (this.flags.contains((Object)Flag.ACCEPTS_INLINE)) {
            return t.blockType == BlockType.INLINE;
        }
        switch (this.blockType) {
            case BLOCK: 
            case INLINE: {
                return t.blockType == BlockType.INLINE;
            }
            case OTHER: {
                return true;
            }
        }
        throw new AssertionError((Object)((Object)((Object)this) + ":" + (Object)((Object)t)));
    }

    public boolean acceptsText() {
        return this.accepts(B);
    }

    public String getText() {
        return StringUtils.toLowerCase(this.name());
    }

    public Attr getAttr(Name attrName) {
        return Attr.index.get(StringUtils.toLowerCase(attrName.toString()));
    }

    public AttrKind getAttrKind(Name attrName) {
        AttrKind k = this.attrs.get((Object)this.getAttr(attrName));
        return k == null ? AttrKind.INVALID : k;
    }

    private static AttrMap attrs(AttrKind k, Attr ... attrs) {
        AttrMap map = new AttrMap();
        for (Attr a : attrs) {
            map.put(a, k);
        }
        return map;
    }

    static HtmlTag get(Name tagName) {
        return index.get(StringUtils.toLowerCase(tagName.toString()));
    }

    static {
        index = new HashMap<String, HtmlTag>();
        for (HtmlTag t : HtmlTag.values()) {
            index.put(t.getText(), t);
        }
    }

    private static class AttrMap
    extends EnumMap<Attr, AttrKind> {
        private static final long serialVersionUID = 0L;

        AttrMap() {
            super(Attr.class);
        }
    }

    public static enum AttrKind {
        INVALID,
        OBSOLETE,
        USE_CSS,
        OK;

    }

    public static enum Attr {
        ABBR,
        ALIGN,
        ALT,
        AXIS,
        BGCOLOR,
        BORDER,
        CELLSPACING,
        CELLPADDING,
        CHAR,
        CHAROFF,
        CLEAR,
        CLASS,
        COLOR,
        COLSPAN,
        COMPACT,
        FACE,
        FRAME,
        HEADERS,
        HEIGHT,
        HREF,
        HSPACE,
        ID,
        NAME,
        NOWRAP,
        REVERSED,
        ROWSPAN,
        RULES,
        SCOPE,
        SIZE,
        SPACE,
        SRC,
        START,
        STYLE,
        SUMMARY,
        TARGET,
        TYPE,
        VALIGN,
        VALUE,
        VSPACE,
        WIDTH;

        static final Map<String, Attr> index;

        public String getText() {
            return StringUtils.toLowerCase(this.name());
        }

        static {
            index = new HashMap<String, Attr>();
            for (Attr t : Attr.values()) {
                index.put(t.getText(), t);
            }
        }
    }

    public static enum Flag {
        ACCEPTS_BLOCK,
        ACCEPTS_INLINE,
        EXPECT_CONTENT,
        NO_NEST;

    }

    public static enum EndKind {
        NONE,
        OPTIONAL,
        REQUIRED;

    }

    public static enum BlockType {
        BLOCK,
        INLINE,
        LIST_ITEM,
        TABLE_ITEM,
        OTHER;

    }
}

