/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.node;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.util.Types;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.nullaway.javacutil.TreeUtils;

public class ArrayTypeNode
extends Node {
    protected final ArrayTypeTree tree;
    protected final Types types;

    public ArrayTypeNode(ArrayTypeTree tree, Types types) {
        super(TreeUtils.typeOf(tree));
        this.tree = tree;
        this.types = types;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitArrayType(this, p);
    }

    public String toString() {
        return this.tree.toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ArrayTypeNode)) {
            return false;
        }
        ArrayTypeNode other = (ArrayTypeNode)obj;
        return this.types.isSameType(this.getType(), other.getType());
    }

    public int hashCode() {
        return Objects.hash(this.getType());
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        return Collections.emptyList();
    }
}

