/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.org.plumelib.util;

import java.util.Collections;
import java.util.IdentityHashMap;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.nullaway.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.nullaway.checker.formatter.qual.FormatBottom;
import org.checkerframework.nullaway.checker.formatter.qual.UnknownFormat;
import org.checkerframework.nullaway.checker.index.qual.LessThanUnknown;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.nullaway.checker.index.qual.SameLenUnknown;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.nullaway.checker.initialization.qual.Initialized;
import org.checkerframework.nullaway.checker.interning.qual.FindDistinct;
import org.checkerframework.nullaway.checker.interning.qual.Interned;
import org.checkerframework.nullaway.checker.interning.qual.UnknownInterned;
import org.checkerframework.nullaway.checker.lock.qual.GuardSatisfied;
import org.checkerframework.nullaway.checker.lock.qual.GuardedBy;
import org.checkerframework.nullaway.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.nullaway.checker.mustcall.qual.MustCall;
import org.checkerframework.nullaway.checker.nonempty.qual.EnsuresNonEmpty;
import org.checkerframework.nullaway.checker.nonempty.qual.EnsuresNonEmptyIf;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.nullaway.checker.regex.qual.UnknownRegex;
import org.checkerframework.nullaway.checker.signature.qual.SignatureUnknown;
import org.checkerframework.nullaway.checker.signedness.qual.Signed;
import org.checkerframework.nullaway.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.nullaway.common.initializedfields.qual.InitializedFields;
import org.checkerframework.nullaway.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.nullaway.common.value.qual.UnknownVal;
import org.checkerframework.nullaway.org.plumelib.util.AbstractMostlySingletonSet;

public final class IdentityMostlySingletonSet<@FormatBottom T>
extends AbstractMostlySingletonSet<T> {
    public IdentityMostlySingletonSet() {
        super(AbstractMostlySingletonSet.State.EMPTY);
    }

    public IdentityMostlySingletonSet(T value) {
        super(AbstractMostlySingletonSet.State.SINGLETON, value);
    }

    @Override
    @EnsuresNonEmpty(value={"this"})
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean add(@GuardSatisfied IdentityMostlySingletonSet<T> this, @FindDistinct T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingletonSet.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                if (this.value == e) {
                    return false;
                }
                this.makeNonSingleton();
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.add(e);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }

    private void makeNonSingleton(@GuardSatisfied IdentityMostlySingletonSet<T> this) {
        this.state = AbstractMostlySingletonSet.State.ANY;
        this.set = Collections.newSetFromMap(new IdentityHashMap(4));
        assert (this.value != null) : "@AssumeAssertion(nullness): previous add is non-null";
        this.set.add(this.value);
        this.value = null;
    }

    @Override
    @EnsuresNonEmptyIf(result=true, expression={"this"})
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean contains(@GuardSatisfied IdentityMostlySingletonSet<T> this, @GuardSatisfied @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @InitializedFields(value={}) Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                return o == this.value;
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.contains(o);
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
    }
}

