/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesLoader.class);

    private PropertiesLoader() {
    }

    public static Properties loadProperties(Resource resource) {
        Properties properties = new Properties();
        try (InputStream inputStream = resource.getInputStream();){
            logger.debug("Loading properties resource: {}", (Object)resource);
            PropertiesLoader.loadProperties(resource.getLocation(), properties, inputStream);
        }
        catch (IOException e) {
            PropertiesLoader.throwPropertiesLoadingFailedException(resource.getLocation(), e);
        }
        return properties;
    }

    public static Properties loadProperties(String path) {
        Properties properties = new Properties();
        try (InputStream in = ResourcePathTypeResolver.class.getClassLoader().getResourceAsStream(path);){
            if (in == null) {
                throw new CitrusRuntimeException(String.format("Failed to locate resource path '%s'!", path));
            }
            PropertiesLoader.loadProperties(path, properties, in);
        }
        catch (IOException e) {
            PropertiesLoader.throwPropertiesLoadingFailedException(path, e);
        }
        return properties;
    }

    private static void throwPropertiesLoadingFailedException(String path, IOException e) {
        throw new CitrusRuntimeException(String.format("Unable to load properties from resource path configuration at '%s'", path), e);
    }

    private static void loadProperties(String path, Properties properties, InputStream in) throws IOException {
        if (path.endsWith(".xml")) {
            properties.loadFromXML(in);
        } else {
            properties.load(in);
        }
    }
}

