/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.nio.charset.StandardCharsets;
import org.citrusframework.context.TestContext;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;

public class TestSource {
    private final String type;
    private final String name;
    private final String filePath;
    private Resource sourceFile;

    public TestSource(String type, String name) {
        this(type, name, "%s.%s".formatted(name, type));
    }

    public TestSource(String type, String name, String filePath) {
        this.type = type;
        this.name = name;
        this.filePath = filePath;
    }

    public TestSource(Class<?> testClass) {
        this("java", testClass.getName());
        String path = testClass.getPackageName().replace('.', '/');
        String fileName = testClass.getName() + ".java";
        this.sourceFile = new Resources.ClasspathResource(path.isEmpty() ? fileName : path + "/" + fileName);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Resource getSourceFile() {
        if (this.sourceFile == null) {
            this.sourceFile = Resources.create(this.filePath);
        }
        return this.sourceFile;
    }

    public Resource getSourceFile(TestContext context) {
        if (this.sourceFile == null) {
            this.sourceFile = Resources.create(context.replaceDynamicContentInString(this.filePath));
        }
        return this.sourceFile;
    }

    public void setSourceFile(Resource sourceFile) {
        this.sourceFile = sourceFile;
    }

    public TestSource sourceCode(String sourceCode) {
        this.sourceFile = new Resources.ByteArrayResource(sourceCode.getBytes(StandardCharsets.UTF_8));
        return this;
    }
}

