/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.annotation;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AnnotationConfigParser<A extends Annotation, T extends Endpoint> {
    public static final Logger logger = LoggerFactory.getLogger(AnnotationConfigParser.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/endpoint/parser";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/endpoint/parser");
    public static final Map<String, AnnotationConfigParser> parsers = new HashMap<String, AnnotationConfigParser>();

    public T parse(A var1, ReferenceResolver var2);

    public static Map<String, AnnotationConfigParser> lookup() {
        if (parsers.isEmpty()) {
            parsers.putAll(TYPE_RESOLVER.resolveAll("", "*"));
            if (logger.isDebugEnabled()) {
                parsers.forEach((k, v) -> logger.debug("Found annotation config parser '{}' as {}", k, v.getClass()));
            }
        }
        return parsers;
    }

    public static Optional<AnnotationConfigParser> lookup(String parser) {
        try {
            AnnotationConfigParser instance;
            if (parser.contains(".")) {
                int separatorIndex = parser.lastIndexOf(46);
                instance = (AnnotationConfigParser)TYPE_RESOLVER.resolve(parser.substring(0, separatorIndex), parser.substring(separatorIndex + 1), new Object[0]);
            } else {
                instance = (AnnotationConfigParser)TYPE_RESOLVER.resolve(parser, new Object[0]);
            }
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            logger.warn("Failed to resolve annotation config parser from resource '{}/{}'", (Object)RESOURCE_PATH, (Object)parser);
            return Optional.empty();
        }
    }
}

