/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.spi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceRegistry;
import org.citrusframework.spi.ReferenceResolver;

public class SimpleReferenceResolver
implements ReferenceResolver,
ReferenceRegistry {
    private final ConcurrentHashMap<String, Object> objectStore = new ConcurrentHashMap();

    @Override
    public <T> T resolve(Class<T> type) {
        return (T)this.objectStore.values().stream().filter(v -> v != null && type.isAssignableFrom(v.getClass())).map(type::cast).findFirst().orElseThrow(() -> new CitrusRuntimeException(String.format("Unable to find bean reference for type '%s'", type)));
    }

    @Override
    public Object resolve(String name) {
        if (!this.objectStore.containsKey(name)) {
            throw new CitrusRuntimeException(String.format("Unable to find bean reference for name '%s'", name));
        }
        return this.objectStore.get(name);
    }

    @Override
    public <T> T resolve(String name, Class<T> type) {
        return (T)this.objectStore.entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> name.equals(entry.getKey()) && type.isAssignableFrom(entry.getValue().getClass())).map(Map.Entry::getValue).map(type::cast).findFirst().orElseThrow(() -> new CitrusRuntimeException(String.format("Unable to find bean reference for name '%s'", name)));
    }

    @Override
    public <T> Map<String, T> resolveAll(Class<T> type) {
        return this.objectStore.entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> type.isAssignableFrom(entry.getValue().getClass())).collect(Collectors.toMap(Map.Entry::getKey, entry -> type.cast(entry.getValue())));
    }

    @Override
    public boolean isResolvable(String name) {
        return this.objectStore.containsKey(name);
    }

    @Override
    public boolean isResolvable(Class<?> type) {
        return this.objectStore.entrySet().stream().filter(entry -> entry.getValue() != null).anyMatch(entry -> type.isAssignableFrom(entry.getValue().getClass()));
    }

    @Override
    public boolean isResolvable(String name, Class<?> type) {
        return this.objectStore.containsKey(name) && type.isAssignableFrom(this.objectStore.get(name).getClass());
    }

    @Override
    public void bind(String name, Object value) {
        if (value != null) {
            this.objectStore.put(name, value);
        }
    }
}

