/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.NoSuchMessageValidatorException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessagePayloadUtils;
import org.citrusframework.message.MessageType;
import org.citrusframework.util.IsJsonPredicate;
import org.citrusframework.util.IsXmlPredicate;
import org.citrusframework.util.IsYamlPredicate;
import org.citrusframework.validation.DefaultEmptyMessageValidator;
import org.citrusframework.validation.DefaultTextEqualsMessageValidator;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.SchemaValidator;
import org.citrusframework.validation.context.SchemaValidationContext;
import org.citrusframework.validation.context.ValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageValidatorRegistry {
    private static final Logger logger = LoggerFactory.getLogger(MessageValidatorRegistry.class);
    public static final String BEAN_NAME = "citrusMessageValidatorRegistry";
    private Map<String, MessageValidator<? extends ValidationContext>> messageValidators = new LinkedHashMap<String, MessageValidator<? extends ValidationContext>>();
    private Map<String, SchemaValidator<? extends SchemaValidationContext>> schemaValidators = new LinkedHashMap<String, SchemaValidator<? extends SchemaValidationContext>>();
    private MessageValidator<? extends ValidationContext> defaultMessageHeaderValidator;
    private final DefaultEmptyMessageValidator defaultEmptyMessageValidator = new DefaultEmptyMessageValidator();
    private final DefaultTextEqualsMessageValidator defaultTextEqualsMessageValidator = new DefaultTextEqualsMessageValidator();

    public List<MessageValidator<? extends ValidationContext>> findMessageValidators(String messageType, Message message) {
        return this.findMessageValidators(messageType, message, false);
    }

    public List<MessageValidator<? extends ValidationContext>> findMessageValidators(String messageType, Message message, boolean mustFindValidator) {
        List<MessageValidator<? extends ValidationContext>> matchingValidators = new ArrayList<MessageValidator<? extends ValidationContext>>();
        for (MessageValidator<? extends ValidationContext> validator : this.messageValidators.values()) {
            if (!validator.supportsMessageType(messageType, message)) continue;
            matchingValidators.add(validator);
        }
        if (this.isEmptyOrDefault(matchingValidators) && message.getPayload() instanceof String && !message.getPayload(String.class).isBlank()) {
            String payload = message.getPayload(String.class).trim();
            if (MessagePayloadUtils.isXml(payload) && !messageType.equals(MessageType.XML.name())) {
                matchingValidators = this.findFallbackMessageValidators(MessageType.XML.name(), message);
            } else if (MessagePayloadUtils.isJson(payload) && !messageType.equals(MessageType.JSON.name())) {
                matchingValidators = this.findFallbackMessageValidators(MessageType.JSON.name(), message);
            } else if (MessagePayloadUtils.isYaml(payload) && !messageType.equals(MessageType.YAML.name())) {
                matchingValidators = this.findFallbackMessageValidators(MessageType.YAML.name(), message);
            } else if (!messageType.equals(MessageType.PLAINTEXT.name())) {
                matchingValidators = this.findFallbackMessageValidators(MessageType.PLAINTEXT.name(), message);
            }
        }
        if (this.isEmptyOrDefault(matchingValidators) && (message.getPayload(String.class) == null || message.getPayload(String.class).isBlank())) {
            matchingValidators.add(this.defaultEmptyMessageValidator);
        }
        if (this.isEmptyOrDefault(matchingValidators)) {
            if (mustFindValidator) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Unable to find proper message validator. Message type is '{}' and message payload is '{}'", (Object)messageType, (Object)message.getPayload(String.class));
                }
                throw new CitrusRuntimeException("Failed to find proper message validator for message");
            }
            logger.warn("Unable to find proper message validator - fallback to default text equals validation.");
            matchingValidators.add(this.defaultTextEqualsMessageValidator);
        }
        logger.debug("Found {} message validators for message", (Object)matchingValidators.size());
        return matchingValidators;
    }

    private boolean isEmptyOrDefault(List<MessageValidator<? extends ValidationContext>> matchingValidators) {
        return matchingValidators.isEmpty() || matchingValidators.stream().allMatch(this::isDefaultMessageHeaderValidator);
    }

    private boolean isDefaultMessageHeaderValidator(MessageValidator<? extends ValidationContext> messageValidator) {
        if (this.defaultMessageHeaderValidator == null) {
            this.defaultMessageHeaderValidator = MessageValidator.lookup("header").orElseThrow(() -> new CitrusRuntimeException("Unable to locate default message header validator"));
        }
        return this.defaultMessageHeaderValidator.getClass().isAssignableFrom(messageValidator.getClass());
    }

    private List<MessageValidator<? extends ValidationContext>> findFallbackMessageValidators(String messageType, Message message) {
        ArrayList<MessageValidator<? extends ValidationContext>> matchingValidators = new ArrayList<MessageValidator<? extends ValidationContext>>();
        for (MessageValidator<? extends ValidationContext> validator : this.messageValidators.values()) {
            if (!validator.supportsMessageType(messageType, message)) continue;
            matchingValidators.add(validator);
        }
        return matchingValidators;
    }

    private List<SchemaValidator<? extends SchemaValidationContext>> findFallbackSchemaValidators(String messageType, Message message) {
        ArrayList<SchemaValidator<? extends SchemaValidationContext>> matchingValidators = new ArrayList<SchemaValidator<? extends SchemaValidationContext>>();
        for (SchemaValidator<? extends SchemaValidationContext> validator : this.schemaValidators.values()) {
            if (!validator.supportsMessageType(messageType, message)) continue;
            matchingValidators.add(validator);
        }
        return matchingValidators;
    }

    public Optional<MessageValidator<? extends ValidationContext>> findMessageValidator(String name) {
        if (this.messageValidators.containsKey(name)) {
            return Optional.of(this.messageValidators.get(name));
        }
        return Optional.empty();
    }

    public MessageValidator<? extends ValidationContext> getMessageValidator(String name) {
        if (this.messageValidators.containsKey(name)) {
            return this.messageValidators.get(name);
        }
        throw new NoSuchMessageValidatorException(String.format("Unable to find message validator with name '%s'", name));
    }

    public void addMessageValidator(String name, MessageValidator<? extends ValidationContext> messageValidator) {
        if (this.messageValidators.containsKey(name) && logger.isDebugEnabled()) {
            logger.debug("Overwriting message validator '{}' in registry", (Object)name);
        }
        this.messageValidators.put(name, messageValidator);
    }

    public void addSchemaValidator(String name, SchemaValidator<? extends SchemaValidationContext> schemaValidator) {
        if (this.schemaValidators.containsKey(name) && logger.isDebugEnabled()) {
            logger.debug("Overwriting message validator '{}' in registry", (Object)name);
        }
        this.schemaValidators.put(name, schemaValidator);
    }

    public void setMessageValidators(Map<String, MessageValidator<? extends ValidationContext>> messageValidators) {
        this.messageValidators = messageValidators;
    }

    public Map<String, MessageValidator<? extends ValidationContext>> getMessageValidators() {
        return this.messageValidators;
    }

    public MessageValidator<? extends ValidationContext> getDefaultMessageValidator() {
        return this.defaultTextEqualsMessageValidator;
    }

    public MessageValidator<? extends ValidationContext> getDefaultMessageHeaderValidator() {
        return this.messageValidators.values().stream().filter(this::isDefaultMessageHeaderValidator).findFirst().orElse(this.defaultMessageHeaderValidator);
    }

    public List<SchemaValidator<? extends SchemaValidationContext>> findSchemaValidators(String messageType, Message message) {
        List<SchemaValidator<? extends SchemaValidationContext>> matchingSchemaValidators = new ArrayList<SchemaValidator<? extends SchemaValidationContext>>();
        for (SchemaValidator<? extends SchemaValidationContext> validator : this.schemaValidators.values()) {
            if (!validator.supportsMessageType(messageType, message)) continue;
            matchingSchemaValidators.add(validator);
        }
        if (matchingSchemaValidators.isEmpty() && message.getPayload() instanceof String && !message.getPayload(String.class).isBlank()) {
            String payload = message.getPayload(String.class).trim();
            if (IsXmlPredicate.getInstance().test(payload) && !messageType.equals(MessageType.XML.name())) {
                matchingSchemaValidators = this.findFallbackSchemaValidators(MessageType.XML.name(), message);
            } else if (IsJsonPredicate.getInstance().test(payload) && !messageType.equals(MessageType.JSON.name())) {
                matchingSchemaValidators = this.findFallbackSchemaValidators(MessageType.JSON.name(), message);
            } else if (IsYamlPredicate.getInstance().test(payload) && !messageType.equals(MessageType.YAML.name())) {
                matchingSchemaValidators = this.findFallbackSchemaValidators(MessageType.YAML.name(), message);
            }
        }
        return matchingSchemaValidators;
    }

    public Optional<SchemaValidator<? extends SchemaValidationContext>> findSchemaValidator(String name) {
        if (this.schemaValidators.containsKey(name)) {
            return Optional.of(this.schemaValidators.get(name));
        }
        return Optional.empty();
    }

    public void setSchemaValidators(Map<String, SchemaValidator<? extends SchemaValidationContext>> schemaValidators) {
        this.schemaValidators = schemaValidators;
    }

    public Map<String, SchemaValidator<? extends SchemaValidationContext>> getSchemaValidators() {
        return this.schemaValidators;
    }
}

