/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.context;

import java.util.Map;
import java.util.Optional;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.validation.context.ValidationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ValidationContext {
    public static final Logger logger = LoggerFactory.getLogger(ValidationContext.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/validation/builder";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/validation/builder");

    default public boolean requiresValidator() {
        return false;
    }

    public void updateStatus(ValidationStatus var1);

    default public ValidationStatus getStatus() {
        return ValidationStatus.UNKNOWN;
    }

    public static Map<String, Builder<?, ?>> lookup() {
        Map<String, Builder<?, ?>> builders = TYPE_RESOLVER.resolveAll();
        if (logger.isDebugEnabled()) {
            builders.forEach((k, v) -> logger.debug("Found validation context builder '{}' as {}", k, v.getClass()));
        }
        return builders;
    }

    public static Optional<Builder<?, ?>> lookup(String builder) {
        try {
            return Optional.of((Builder)TYPE_RESOLVER.resolve(builder, new Object[0]));
        }
        catch (CitrusRuntimeException e) {
            logger.warn("Failed to resolve validation context builder from resource '{}/{}'", (Object)RESOURCE_PATH, (Object)builder);
            return Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface Builder<T extends ValidationContext, B extends Builder<T, B>> {
        public T build();
    }
}

