/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.citrusframework.json.JsonNodeStringBuilder;
import org.citrusframework.json.JsonStringBuilder;
import org.citrusframework.message.Message;
import org.citrusframework.yaml.YamlNodeStringBuilder;
import org.citrusframework.yaml.YamlStringBuilder;

public class TestActionResult {
    private final String name;
    private final String path;
    private String error;
    private final List<TestActionResult> actions = new ArrayList<TestActionResult>();
    private final List<TestActionResult> iterations = new ArrayList<TestActionResult>();
    private Message message;

    public TestActionResult(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public boolean isFailed() {
        return this.error != null;
    }

    public void addAction(TestActionResult result) {
        this.actions.add(result);
    }

    public void setActions(List<TestActionResult> actions) {
        this.actions.addAll(actions);
    }

    public List<TestActionResult> getActions() {
        return this.actions;
    }

    public String toJson() {
        JsonNodeStringBuilder builder = new JsonStringBuilder().withObject().withProperty("name", this.name).withProperty("path", this.path);
        if (Objects.nonNull(this.error)) {
            builder.withPropertyEscaped("error", this.error);
        }
        if (Objects.nonNull(this.message)) {
            builder.withProperty("message").withObject().withProperty("headers").withArray(this.message.getHeaders()).withProperty("headerData").withArray(this.message.getHeaderData().stream().map(String::getBytes).map(Base64.getEncoder()::encodeToString).toList()).withProperty("payload", Base64.getEncoder().encodeToString(this.message.getPayload(byte[].class))).closeObject();
        }
        if (!this.actions.isEmpty()) {
            builder.withProperty("actions").withArray().append(this.actions.stream().map(TestActionResult::toJson).collect(Collectors.joining(","))).closeArray();
        }
        if (!this.iterations.isEmpty()) {
            builder.withProperty("iterations").withArray().append(this.iterations.stream().map(TestActionResult::toJson).collect(Collectors.joining(","))).closeArray();
        }
        return builder.closeObject().toString();
    }

    public String toYaml() {
        YamlNodeStringBuilder builder = new YamlStringBuilder().withProperty("name", this.name).withProperty("path", this.path);
        if (Objects.nonNull(this.error)) {
            builder.withPropertyBlockStyle("error", this.error);
        }
        if (Objects.nonNull(this.message)) {
            builder.withObject("message").withObject("headers").withArray().withProperties(this.message.getHeaders()).closeArray().closeObject().withArray("headerData", this.message.getHeaderData().stream().map(String::getBytes).map(Base64.getEncoder()::encodeToString).toList()).withPropertyBlockStyle("payload", this.message.getPayload(String.class)).closeObject();
        }
        if (!this.actions.isEmpty()) {
            builder.withObject("actions").withArray().append(this.actions.stream().map(TestActionResult::toYaml).toList()).closeArray().closeObject();
        }
        if (!this.iterations.isEmpty()) {
            builder.withObject("iterations").withArray().append(this.iterations.stream().map(TestActionResult::toYaml).toList()).closeArray().closeObject();
        }
        return builder.toString();
    }

    public void addIteration(TestActionResult iteration) {
        this.iterations.add(iteration);
    }

    public List<TestActionResult> getIterations() {
        return this.iterations;
    }

    public void setIterations(List<TestActionResult> iterations) {
        this.iterations.addAll(iterations);
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Message getMessage() {
        return this.message;
    }
}

